/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.ObjectHeader;
import io.jhdf.Utils;
import io.jhdf.api.Group;
import io.jhdf.api.dataset.ContiguousDataset;
import io.jhdf.dataset.DatasetBase;
import io.jhdf.exceptions.HdfException;
import io.jhdf.filter.PipelineFilterWithData;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ContiguousDatasetImpl
extends DatasetBase
implements ContiguousDataset {
    final DataLayoutMessage.ContiguousDataLayoutMessage contiguousDataLayoutMessage = this.getHeaderMessage(DataLayoutMessage.ContiguousDataLayoutMessage.class);

    public ContiguousDatasetImpl(HdfBackingStorage hdfBackingStorage, long address, String name, Group parent, ObjectHeader oh) {
        super(hdfBackingStorage, address, name, parent, oh);
    }

    @Override
    public ByteBuffer getDataBuffer() {
        try {
            ByteBuffer data = this.hdfBackingStorage.map(this.contiguousDataLayoutMessage.getAddress(), this.getSizeInBytes());
            this.convertToCorrectEndiness(data);
            return data;
        }
        catch (Exception e) {
            throw new HdfException("Failed to map data buffer for dataset '" + this.getPath() + "'", e);
        }
    }

    @Override
    public ByteBuffer getSliceDataBuffer(long[] sliceOffset, int[] sliceDimensions) {
        int totalElementsInSlice = Arrays.stream(sliceDimensions).reduce(1, Math::multiplyExact);
        ByteBuffer byteBuffer = ByteBuffer.allocate(totalElementsInSlice * this.getDataType().getSize());
        this.convertToCorrectEndiness(byteBuffer);
        long[] currentOffset = (long[])sliceOffset.clone();
        this.readSlicesToBuffer(-1, sliceOffset, sliceDimensions, currentOffset, byteBuffer);
        byteBuffer.flip();
        return byteBuffer;
    }

    private void readSlicesToBuffer(int dimensionIndex, long[] sliceOffset, int[] sliceDimensions, long[] currentOffset, ByteBuffer byteBuffer) {
        if (++dimensionIndex < sliceDimensions.length - 1) {
            for (long i = 0L; i < (long)sliceDimensions[dimensionIndex]; ++i) {
                currentOffset[dimensionIndex] = sliceOffset[dimensionIndex] + i;
                this.readSlicesToBuffer(dimensionIndex, sliceOffset, sliceDimensions, currentOffset, byteBuffer);
            }
        } else {
            long offsetBytes = Utils.dimensionIndexToLinearIndex(currentOffset, this.getDimensions()) * (long)this.getDataType().getSize();
            long fileOffset = this.contiguousDataLayoutMessage.getAddress() + offsetBytes;
            int fastestDimLengthBytes = sliceDimensions[sliceDimensions.length - 1] * this.getDataType().getSize();
            byteBuffer.put(this.hdfBackingStorage.readBufferFromAddress(fileOffset, fastestDimLengthBytes));
        }
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.getDataBuffer();
    }

    @Override
    public long getDataAddress() {
        return this.contiguousDataLayoutMessage.getAddress();
    }

    @Override
    public boolean isEmpty() {
        return this.contiguousDataLayoutMessage.getAddress() == -1L;
    }

    @Override
    public List<PipelineFilterWithData> getFilters() {
        return Collections.emptyList();
    }
}

