/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.filter;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfFilterException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.filter.Filter;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public class BitShuffleFilter
implements Filter {
    private static final int BSHUF_MIN_RECOMMEND_BLOCK = 128;
    private static final int BSHUF_BLOCKED_MULT = 8;
    private static final int BSHUF_TARGET_BLOCK_SIZE_B = 8192;
    public static final int NO_COMPRESSION = 0;
    public static final int LZ4_COMPRESSION = 2;
    public static final int ZSTD_COMPRESSION = 3;
    private final LazyInitializer<LZ4SafeDecompressor> lzz4Decompressor = new LazyInitializer<LZ4SafeDecompressor>(){

        protected LZ4SafeDecompressor initialize() {
            return LZ4Factory.fastestJavaInstance().safeDecompressor();
        }
    };

    @Override
    public int getId() {
        return 32008;
    }

    @Override
    public String getName() {
        return "bitshuffle";
    }

    @Override
    public byte[] decode(byte[] encodedData, int[] filterData) {
        int blockSize = filterData[3] == 0 ? this.getDefaultBlockSize(filterData[2]) : filterData[3];
        int blockSizeBytes = blockSize * filterData[2];
        switch (filterData[4]) {
            case 0: {
                return this.noCompression(encodedData, filterData, blockSizeBytes);
            }
            case 2: {
                return this.lz4Compression(encodedData, filterData);
            }
            case 3: {
                throw new UnsupportedHdfException("Bitshuffle zstd not implemented");
            }
        }
        throw new HdfFilterException("Unknown compression type: " + filterData[4]);
    }

    private byte[] lz4Compression(byte[] encodedData, int[] filterData) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(encodedData);
        long totalDecompressedSize = Utils.readBytesAsUnsignedLong(byteBuffer, 8);
        byte[] decompressed = new byte[Math.toIntExact(totalDecompressedSize)];
        int decompressedBlockSize = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
        byte[] decomressedBuffer = new byte[decompressedBlockSize];
        byte[] compressedBuffer = new byte[]{};
        long blocks2 = (long)decompressedBlockSize > totalDecompressedSize ? 1L : totalDecompressedSize / (long)decompressedBlockSize;
        int offset = 0;
        for (long i = 0L; i < blocks2; ++i) {
            int compressedBlockLength = byteBuffer.getInt();
            if (compressedBlockLength > compressedBuffer.length) {
                compressedBuffer = new byte[compressedBlockLength];
            }
            byteBuffer.get(compressedBuffer, 0, compressedBlockLength);
            try {
                int decompressedBytes = ((LZ4SafeDecompressor)this.lzz4Decompressor.get()).decompress(compressedBuffer, 0, compressedBlockLength, decomressedBuffer, 0);
                this.unshuffle(decomressedBuffer, decompressedBytes, decompressed, offset, filterData[2]);
                offset += decompressedBytes;
                continue;
            }
            catch (Exception e) {
                throw new HdfFilterException("Failed LZ4 decompression", e);
            }
        }
        if (byteBuffer.hasRemaining()) {
            byteBuffer.get(decompressed, offset, byteBuffer.remaining());
        }
        return decompressed;
    }

    private byte[] noCompression(byte[] encodedData, int[] filterData, int blockSizeBytes) {
        byte[] unshuffledBlock;
        byte[] blockData;
        int blocks = encodedData.length / blockSizeBytes;
        byte[] unshuffled = new byte[encodedData.length];
        for (int i = 0; i < blocks; ++i) {
            blockData = new byte[blockSizeBytes];
            System.arraycopy(encodedData, i * blockSizeBytes, blockData, 0, blockSizeBytes);
            unshuffledBlock = new byte[blockSizeBytes];
            this.unshuffle(blockData, filterData[2], unshuffledBlock);
            System.arraycopy(unshuffledBlock, 0, unshuffled, i * blockSizeBytes, blockSizeBytes);
        }
        if (blocks * blockSizeBytes < encodedData.length) {
            int finalBlockSize = encodedData.length - blocks * blockSizeBytes;
            blockData = new byte[finalBlockSize];
            System.arraycopy(encodedData, blocks * blockSizeBytes, blockData, 0, finalBlockSize);
            unshuffledBlock = new byte[finalBlockSize];
            this.unshuffle(blockData, filterData[2], unshuffledBlock);
            System.arraycopy(unshuffledBlock, 0, unshuffled, blocks * blockSizeBytes, finalBlockSize);
        }
        return unshuffled;
    }

    protected void unshuffle(byte[] shuffledBuffer, int elementSize, byte[] unshuffledBuffer) {
        this.unshuffle(shuffledBuffer, shuffledBuffer.length, unshuffledBuffer, 0, elementSize);
    }

    protected void unshuffle(byte[] shuffledBuffer, int shuffledLength, byte[] unshuffledBuffer, int unshuffledOffset, int elementSize) {
        int elements = shuffledLength / elementSize;
        int elementSizeBits = elementSize * 8;
        int unshuffledOffsetBits = unshuffledOffset * 8;
        if (elements < 8) {
            System.arraycopy(shuffledBuffer, 0, unshuffledBuffer, 0, shuffledLength);
            return;
        }
        int elementsToShuffle = elements - elements % 8;
        int elementsToCopy = elements - elementsToShuffle;
        int pos = 0;
        for (int i = 0; i < elementSizeBits; ++i) {
            for (int j = 0; j < elementsToShuffle; ++j) {
                boolean bit = Utils.getBit(shuffledBuffer, pos);
                if (bit) {
                    Utils.setBit(unshuffledBuffer, unshuffledOffsetBits + j * elementSizeBits + i, true);
                }
                ++pos;
            }
        }
        System.arraycopy(shuffledBuffer, elementsToShuffle * elementSize, unshuffledBuffer, elementsToShuffle * elementSize, elementsToCopy * elementSize);
    }

    private int getDefaultBlockSize(int elementSize) {
        int defaultBlockSize = 8192 / elementSize;
        defaultBlockSize = defaultBlockSize / 8 * 8;
        return Integer.max(defaultBlockSize, 128);
    }
}

