/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.filter;

import io.jhdf.filter.Filter;

public class ByteShuffleFilter
implements Filter {
    @Override
    public int getId() {
        return 2;
    }

    @Override
    public String getName() {
        return "shuffle";
    }

    @Override
    public byte[] decode(byte[] data, int[] filterData) {
        int dataSize = filterData[0];
        if (dataSize == 1) {
            return data;
        }
        int elements = data.length / dataSize;
        byte[] out = new byte[data.length];
        int pos = 0;
        for (int i = 0; i < dataSize; ++i) {
            for (int j = 0; j < elements; ++j) {
                out[j * dataSize + i] = data[pos];
                ++pos;
            }
        }
        if (pos < data.length) {
            System.arraycopy(data, pos, out, pos, data.length - pos);
        }
        return out;
    }
}

