/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.InvalidTruncateTimeException;
import org.apache.tephra.TransactionSystemClient;
import org.apache.tephra.runtime.ConfigModule;
import org.apache.tephra.runtime.DiscoveryModules;
import org.apache.tephra.runtime.TransactionClientModule;
import org.apache.tephra.runtime.TransactionModules;
import org.apache.tephra.runtime.ZKModule;
import org.apache.tephra.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.tephra.shaded.com.google.common.base.Joiner;
import org.apache.tephra.shaded.com.google.common.base.Splitter;
import org.apache.tephra.shaded.com.google.common.collect.Lists;
import org.apache.tephra.shaded.com.google.common.collect.Sets;
import org.apache.tephra.shaded.org.apache.twill.zookeeper.ZKClientService;

public class TransactionAdmin {
    private static final String OPT_TRUNCATE_INVALID_TX = "--truncate-invalid-tx";
    private static final String OPT_TRUNCATE_INVALID_TX_BEFORE = "--truncate-invalid-tx-before";
    private static final String OPT_GET_INVALID_TX_SIZE = "--get-invalid-tx-size";
    private final PrintStream out;
    private final PrintStream err;

    public static void main(String[] args) {
        TransactionAdmin txAdmin = new TransactionAdmin(System.out, System.err);
        int status2 = txAdmin.doMain(args, new Configuration());
        System.exit(status2);
    }

    public TransactionAdmin(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @VisibleForTesting
    int doMain(String[] args, Configuration conf) {
        block22: {
            if (args.length < 1) {
                this.printUsage();
                return 1;
            }
            Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf), new ZKModule(), new DiscoveryModules().getDistributedModules(), new TransactionModules().getDistributedModules(), new TransactionClientModule()});
            ZKClientService zkClient = (ZKClientService)injector.getInstance(ZKClientService.class);
            zkClient.startAndWait();
            try {
                TransactionSystemClient txClient = (TransactionSystemClient)injector.getInstance(TransactionSystemClient.class);
                String option = args[0];
                if (option.equals(OPT_TRUNCATE_INVALID_TX)) {
                    Set<Long> txIds;
                    if (args.length != 2) {
                        this.printUsage();
                        int n = 1;
                        return n;
                    }
                    try {
                        txIds = this.parseTxIds(args[1]);
                    }
                    catch (NumberFormatException e) {
                        this.err.println("NumberFormatException: " + e.getMessage());
                        int n = 1;
                        zkClient.stopAndWait();
                        return n;
                    }
                    if (!txIds.isEmpty()) {
                        this.out.println("Invalid list size before truncation: " + txClient.getInvalidSize());
                        txClient.truncateInvalidTx(txIds);
                        this.out.println("Invalid list size after truncation: " + txClient.getInvalidSize());
                    }
                    break block22;
                }
                if (option.equals(OPT_TRUNCATE_INVALID_TX_BEFORE)) {
                    if (args.length != 2) {
                        this.printUsage();
                        int txIds = 1;
                        return txIds;
                    }
                    try {
                        long time = Long.parseLong(args[1]);
                        this.out.println("Invalid list size before truncation: " + txClient.getInvalidSize());
                        txClient.truncateInvalidTxBefore(time);
                        this.out.println("Invalid list size after truncation: " + txClient.getInvalidSize());
                        break block22;
                    }
                    catch (InvalidTruncateTimeException e) {
                        this.err.println(e.getMessage());
                        int n = 1;
                        zkClient.stopAndWait();
                        return n;
                    }
                    catch (NumberFormatException e) {
                        this.err.println("NumberFormatException: " + e.getMessage());
                        int n = 1;
                        zkClient.stopAndWait();
                        return n;
                    }
                }
                if (option.equals(OPT_GET_INVALID_TX_SIZE)) {
                    if (args.length != 1) {
                        this.printUsage();
                        int n = 1;
                        return n;
                    }
                    this.out.println("Invalid list size: " + txClient.getInvalidSize());
                    break block22;
                }
                this.printUsage();
                int n = 1;
                return n;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                zkClient.stopAndWait();
            }
        }
        return 0;
    }

    private Set<Long> parseTxIds(String option) throws NumberFormatException {
        HashSet<Long> txIds = Sets.newHashSet();
        for (String str : Splitter.on(',').split(option)) {
            txIds.add(Long.parseLong(str));
        }
        return txIds;
    }

    private void printUsage() {
        String programName = TransactionAdmin.class.getSimpleName();
        String spaces = "     ";
        ArrayList<String> options = Lists.newArrayList();
        options.add(TransactionAdmin.join("Usage: "));
        options.add(TransactionAdmin.join(spaces, programName, OPT_TRUNCATE_INVALID_TX, "<tx1,tx2,...>"));
        options.add(TransactionAdmin.join(spaces, programName, OPT_TRUNCATE_INVALID_TX_BEFORE, "<time in secs>"));
        options.add(TransactionAdmin.join(spaces, programName, OPT_GET_INVALID_TX_SIZE));
        String usage = Joiner.on(System.getProperty("line.separator")).join(options);
        this.err.println(usage);
    }

    private static String join(String ... args) {
        return Joiner.on(" ").join(args);
    }
}

