/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.distributed;

import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.distributed.RetryStrategy;
import org.apache.tephra.distributed.RetryStrategyProvider;

public class RetryNTimes
extends RetryStrategy {
    private int attempts = 0;
    private int limit;

    private RetryNTimes(int maxAttempts) {
        this.limit = maxAttempts;
    }

    @Override
    public boolean failOnce() {
        ++this.attempts;
        return this.attempts < this.limit;
    }

    public static class Provider
    implements RetryStrategyProvider {
        int nTimes = 2;

        @Override
        public void configure(Configuration config) {
            this.nTimes = config.getInt("data.tx.client.retry.attempts", this.nTimes);
        }

        @Override
        public RetryStrategy newRetryStrategy() {
            return new RetryNTimes(this.nTimes);
        }

        public String toString() {
            return this.nTimes + " attempts without delay";
        }
    }
}

