/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.tephra.shaded.org.apache.twill.api.Command;
import org.apache.tephra.shaded.org.apache.twill.api.TwillContext;
import org.apache.tephra.shaded.org.apache.twill.api.TwillRunnable;
import org.apache.tephra.shaded.org.apache.twill.api.TwillRunnableSpecification;

public abstract class AbstractTwillRunnable
implements TwillRunnable {
    private Map<String, String> args;
    private TwillContext context;

    protected AbstractTwillRunnable() {
        this(Collections.emptyMap());
    }

    protected AbstractTwillRunnable(Map<String, String> args) {
        this.args = Collections.unmodifiableMap(new HashMap<String, String>(args));
    }

    @Override
    public TwillRunnableSpecification configure() {
        return TwillRunnableSpecification.Builder.with().setName(this.getClass().getSimpleName()).withConfigs(this.args).build();
    }

    @Override
    public void initialize(TwillContext context) {
        this.context = context;
        this.args = context.getSpecification().getConfigs();
    }

    @Override
    public void handleCommand(Command command) throws Exception {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }

    protected Map<String, String> getArguments() {
        return this.args;
    }

    protected String getArgument(String key) {
        return this.args.get(key);
    }

    protected TwillContext getContext() {
        return this.context;
    }
}

