/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.tephra.shaded.com.google.common.base.Throwables;
import org.apache.tephra.shaded.com.google.common.collect.ImmutableList;
import org.apache.tephra.shaded.com.google.common.collect.Lists;
import org.apache.tephra.shaded.com.google.common.collect.Sets;
import org.apache.tephra.shaded.com.google.common.io.ByteStreams;
import org.apache.tephra.shaded.org.apache.twill.api.ClassAcceptor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public final class Dependencies {
    public static void findClassDependencies(ClassLoader classLoader, ClassAcceptor acceptor, String ... classesToResolve) throws IOException {
        Dependencies.findClassDependencies(classLoader, acceptor, ImmutableList.copyOf(classesToResolve));
    }

    public static void findClassDependencies(ClassLoader classLoader, ClassAcceptor acceptor, Iterable<String> classesToResolve) throws IOException {
        final HashSet<String> seenClasses = Sets.newHashSet(classesToResolve);
        final LinkedList<String> classes = Lists.newLinkedList(classesToResolve);
        while (!classes.isEmpty()) {
            String className = (String)classes.remove();
            URL classUrl = Dependencies.getClassURL(className, classLoader);
            if (classUrl == null || !acceptor.accept(className, classUrl, Dependencies.getClassPathURL(className, classUrl))) continue;
            InputStream is = classUrl.openStream();
            Throwable throwable = null;
            try {
                new ClassReader(ByteStreams.toByteArray(is)).accept((ClassVisitor)new DependencyClassVisitor(new DependencyAcceptor(){

                    @Override
                    public void accept(String className) {
                        if (seenClasses.add(className)) {
                            classes.add(className);
                        }
                    }
                }), 6);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private static URL getClassURL(String className, ClassLoader classLoader) {
        String resourceName = className.replace('.', '/') + ".class";
        return classLoader.getResource(resourceName);
    }

    private static URL getClassPathURL(String className, URL classUrl) {
        try {
            if ("file".equals(classUrl.getProtocol())) {
                String path = classUrl.getFile();
                int endIdx = path.length() - className.length() - ".class".length();
                if (endIdx > 1) {
                    --endIdx;
                }
                return new URL("file", "", -1, path.substring(0, endIdx));
            }
            if ("jar".equals(classUrl.getProtocol())) {
                String path = classUrl.getFile();
                return URI.create(path.substring(0, path.indexOf("!/"))).toURL();
            }
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate(e);
        }
        throw new IllegalStateException("Unsupported class URL: " + classUrl);
    }

    private Dependencies() {
    }

    private static final class DependencyClassVisitor
    extends ClassVisitor {
        private final SignatureVisitor signatureVisitor;
        private final AnnotationVisitor annotationVisitor;
        private final DependencyAcceptor acceptor;

        public DependencyClassVisitor(DependencyAcceptor acceptor) {
            super(327680);
            this.acceptor = acceptor;
            this.signatureVisitor = this.createSignatureVisitor();
            this.annotationVisitor = this.createAnnotationVisitor();
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.addClass(name);
            if (signature != null) {
                new SignatureReader(signature).accept(this.signatureVisitor);
            } else {
                this.addClass(superName);
                this.addClasses(interfaces);
            }
        }

        public void visitOuterClass(String owner, String name, String desc) {
            this.addClass(owner);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!visible) {
                return null;
            }
            this.addType(Type.getType((String)desc));
            return this.annotationVisitor;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            this.addClass(name);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (signature != null) {
                new SignatureReader(signature).acceptType(this.signatureVisitor);
            } else {
                this.addType(Type.getType((String)desc));
            }
            return new FieldVisitor(327680){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (!visible) {
                        return null;
                    }
                    DependencyClassVisitor.this.addType(Type.getType((String)desc));
                    return DependencyClassVisitor.this.annotationVisitor;
                }
            };
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (signature != null) {
                new SignatureReader(signature).accept(this.signatureVisitor);
            } else {
                this.addMethod(desc);
            }
            this.addClasses(exceptions);
            return new MethodVisitor(327680){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (!visible) {
                        return null;
                    }
                    DependencyClassVisitor.this.addType(Type.getType((String)desc));
                    return DependencyClassVisitor.this.annotationVisitor;
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    if (!visible) {
                        return null;
                    }
                    DependencyClassVisitor.this.addType(Type.getType((String)desc));
                    return DependencyClassVisitor.this.annotationVisitor;
                }

                public void visitTypeInsn(int opcode, String type) {
                    DependencyClassVisitor.this.addType(Type.getObjectType((String)type));
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    DependencyClassVisitor.this.addType(Type.getObjectType((String)owner));
                    DependencyClassVisitor.this.addType(Type.getType((String)desc));
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    DependencyClassVisitor.this.addType(Type.getObjectType((String)owner));
                    DependencyClassVisitor.this.addMethod(desc);
                }

                public void visitLdcInsn(Object cst) {
                    if (cst instanceof Type) {
                        DependencyClassVisitor.this.addType((Type)cst);
                    }
                }

                public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
                    if (!visible) {
                        return null;
                    }
                    DependencyClassVisitor.this.addType(Type.getType((String)desc));
                    return DependencyClassVisitor.this.annotationVisitor;
                }

                public void visitMultiANewArrayInsn(String desc, int dims) {
                    DependencyClassVisitor.this.addType(Type.getType((String)desc));
                }

                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                    if (signature != null) {
                        new SignatureReader(signature).acceptType(DependencyClassVisitor.this.signatureVisitor);
                    } else {
                        DependencyClassVisitor.this.addType(Type.getType((String)desc));
                    }
                }
            };
        }

        private void addClass(String internalName) {
            if (internalName == null || internalName.startsWith("java/")) {
                return;
            }
            this.acceptor.accept(Type.getObjectType((String)internalName).getClassName());
        }

        private void addClasses(String[] classes) {
            if (classes != null) {
                for (String clz : classes) {
                    this.addClass(clz);
                }
            }
        }

        private void addType(Type type) {
            if (type.getSort() == 9) {
                type = type.getElementType();
            }
            if (type.getSort() == 10) {
                this.addClass(type.getInternalName());
            }
        }

        private void addMethod(String desc) {
            this.addType(Type.getReturnType((String)desc));
            for (Type type : Type.getArgumentTypes((String)desc)) {
                this.addType(type);
            }
        }

        private SignatureVisitor createSignatureVisitor() {
            return new SignatureVisitor(327680){
                private String currentClass;

                public void visitClassType(String name) {
                    this.currentClass = name;
                    DependencyClassVisitor.this.addClass(name);
                }

                public void visitInnerClassType(String name) {
                    DependencyClassVisitor.this.addClass(this.currentClass + "$" + name);
                }
            };
        }

        private AnnotationVisitor createAnnotationVisitor() {
            return new AnnotationVisitor(327680){

                public void visit(String name, Object value) {
                    if (value instanceof Type) {
                        DependencyClassVisitor.this.addType((Type)value);
                    }
                }

                public AnnotationVisitor visitAnnotation(String name, String desc) {
                    DependencyClassVisitor.this.addType(Type.getType((String)desc));
                    return this;
                }

                public AnnotationVisitor visitArray(String name) {
                    return this;
                }

                public void visitEnum(String name, String desc, String value) {
                    DependencyClassVisitor.this.addType(Type.getType((String)desc));
                }
            };
        }
    }

    private static interface DependencyAcceptor {
        public void accept(String var1);
    }
}

