/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.txprune;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionManager;
import org.apache.tephra.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.tephra.txprune.TransactionPruningPlugin;
import org.apache.tephra.util.TxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionPruningRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionPruningRunnable.class);
    private final TransactionManager txManager;
    private final Map<String, TransactionPruningPlugin> plugins;
    private final long txMaxLifetimeMillis;
    private final long txPruneBufferMillis;

    public TransactionPruningRunnable(TransactionManager txManager, Map<String, TransactionPruningPlugin> plugins, long txMaxLifetimeMillis, long txPruneBufferMillis) {
        this.txManager = txManager;
        this.plugins = plugins;
        this.txMaxLifetimeMillis = txMaxLifetimeMillis;
        this.txPruneBufferMillis = txPruneBufferMillis;
    }

    @Override
    public void run() {
        try {
            Transaction tx = this.txManager.startShort();
            this.txManager.abort(tx);
            if (tx.getInvalids().length == 0) {
                LOG.info("Invalid list is empty, not running transaction pruning");
                return;
            }
            long now = this.getTime();
            long inactiveTransactionBound = TxUtils.getInactiveTxBound(now, this.txMaxLifetimeMillis + this.txPruneBufferMillis);
            LOG.info("Starting invalid prune run for time {} and inactive transaction bound {}", (Object)now, (Object)inactiveTransactionBound);
            ArrayList<Long> pruneUpperBounds = new ArrayList<Long>();
            for (Map.Entry<String, TransactionPruningPlugin> entry : this.plugins.entrySet()) {
                String name = entry.getKey();
                TransactionPruningPlugin plugin = entry.getValue();
                try {
                    LOG.debug("Fetching prune upper bound using plugin {}", (Object)name);
                    long pruneUpperBound = plugin.fetchPruneUpperBound(now, inactiveTransactionBound);
                    LOG.debug("Got prune upper bound {} from plugin {}", (Object)pruneUpperBound, (Object)name);
                    pruneUpperBounds.add(pruneUpperBound);
                }
                catch (Exception e) {
                    LOG.error("Aborting invalid prune run for time {} due to exception from plugin {}", new Object[]{now, name, e});
                    return;
                }
            }
            long minPruneUpperBound = (Long)Collections.min(pruneUpperBounds);
            LOG.info("Got minimum prune upper bound {} across all plugins", (Object)minPruneUpperBound);
            if (minPruneUpperBound <= 0L) {
                LOG.info("Not pruning invalid list since minimum prune upper bound ({}) is less than 1", (Object)minPruneUpperBound);
                return;
            }
            long[] invalids = tx.getInvalids();
            TreeSet<Long> toTruncate = new TreeSet<Long>();
            LOG.debug("Invalid list: {}", (Object)invalids);
            for (long invalid : invalids) {
                if (invalid > minPruneUpperBound) continue;
                toTruncate.add(invalid);
            }
            if (toTruncate.isEmpty()) {
                LOG.info("Not pruning invalid list since the min prune upper bound {} is greater than the min invalid id {}", (Object)minPruneUpperBound, (Object)invalids[0]);
                return;
            }
            LOG.debug("Removing the following invalid ids from the invalid list", toTruncate);
            this.txManager.truncateInvalidTx(toTruncate);
            LOG.info("Removed {} invalid ids from the invalid list", (Object)toTruncate.size());
            Long maxPrunedInvalid = toTruncate.last();
            for (Map.Entry<String, TransactionPruningPlugin> entry : this.plugins.entrySet()) {
                String name = entry.getKey();
                TransactionPruningPlugin plugin = entry.getValue();
                try {
                    LOG.debug("Calling prune complete on plugin {}", (Object)name);
                    plugin.pruneComplete(now, maxPrunedInvalid);
                }
                catch (Exception e) {
                    LOG.error("Got error while calling prune complete on plugin {}", (Object)name, (Object)e);
                }
            }
            LOG.info("Invalid prune run for time {} is complete", (Object)now);
        }
        catch (Exception e) {
            LOG.error("Got exception during invalid list prune run", (Throwable)e);
        }
    }

    @VisibleForTesting
    long getTime() {
        return System.currentTimeMillis();
    }
}

