/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.util;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tephra.shaded.com.google.common.base.Preconditions;

public class TimeMathParser {
    private static final String NOW = "now";
    private static final String VALID_UNITS = "ms|s|m|h|d";
    private static final Pattern OP_PATTERN = Pattern.compile("([-+])(\\d+)(ms|s|m|h|d)");
    private static final Pattern RESOLUTION_PATTERN = Pattern.compile("(\\d+)(ms|s|m|h|d)");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("^(\\d+)$");

    private static long convertToMilliseconds(String op, long num, String unitStr) {
        long milliseconds;
        if ("ms".equals(unitStr)) {
            milliseconds = num;
        } else if ("s".equals(unitStr)) {
            milliseconds = TimeUnit.SECONDS.toMillis(num);
        } else if ("m".equals(unitStr)) {
            milliseconds = TimeUnit.MINUTES.toMillis(num);
        } else if ("h".equals(unitStr)) {
            milliseconds = TimeUnit.HOURS.toMillis(num);
        } else if ("d".equals(unitStr)) {
            milliseconds = TimeUnit.DAYS.toMillis(num);
        } else {
            throw new IllegalArgumentException("invalid time unit " + unitStr + ", should be one of 'ms', 's', 'm', 'h', 'd'");
        }
        if ("+".equals(op)) {
            return milliseconds;
        }
        if ("-".equals(op)) {
            return 0L - milliseconds;
        }
        throw new IllegalArgumentException("invalid operation " + op + ", should be either '+' or '-'");
    }

    private static long convertToMilliseconds(long num, String unitStr) {
        return TimeMathParser.convertToMilliseconds("+", num, unitStr);
    }

    public static long nowInSeconds() {
        return TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public static int resolutionInSeconds(String resolutionStr) {
        Matcher matcher = RESOLUTION_PATTERN.matcher(resolutionStr);
        int output = 0;
        while (matcher.find()) {
            output = (int)((long)output + TimeUnit.MILLISECONDS.toSeconds(TimeMathParser.convertToMilliseconds(Long.parseLong(matcher.group(1)), matcher.group(2))));
        }
        return output;
    }

    public static long parseTimeInSeconds(String timeStr) {
        return TimeMathParser.parseTime(timeStr, TimeUnit.SECONDS);
    }

    public static long parseTime(String timeStr, TimeUnit timeUnit) {
        return TimeMathParser.parseTime(System.currentTimeMillis(), timeStr, timeUnit);
    }

    public static long parseTimeInSeconds(long now, String timeStr) {
        return TimeMathParser.parseTime(TimeUnit.MILLISECONDS.convert(now, TimeUnit.SECONDS), timeStr, TimeUnit.SECONDS);
    }

    public static long parseTime(long now, String timeStr, TimeUnit timeUnit) {
        Preconditions.checkNotNull(timeStr);
        if (NOW.equals(timeStr.toUpperCase())) {
            return now;
        }
        Matcher matcher = TIMESTAMP_PATTERN.matcher(timeStr);
        if (matcher.matches()) {
            return Long.parseLong(timeStr);
        }
        long output = now;
        if (timeStr.startsWith(NOW)) {
            matcher = OP_PATTERN.matcher(timeStr);
            int prevEndPos = 3;
            while (matcher.find()) {
                if (matcher.start() != prevEndPos) {
                    throw new IllegalArgumentException("invalid time format " + timeStr);
                }
                output += TimeMathParser.convertToMilliseconds(matcher.group(1), Long.parseLong(matcher.group(2)), matcher.group(3));
                prevEndPos = matcher.end();
            }
            if (prevEndPos != timeStr.length()) {
                throw new IllegalArgumentException("invalid time format " + timeStr);
            }
        } else {
            throw new IllegalArgumentException("invalid time format " + timeStr);
        }
        return timeUnit.convert(output, TimeUnit.MILLISECONDS);
    }
}

