/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.visibility;

import java.util.Collection;
import java.util.TreeSet;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionAware;
import org.apache.tephra.shaded.com.google.common.primitives.Bytes;
import org.apache.tephra.shaded.com.google.common.primitives.Longs;
import org.apache.tephra.shaded.com.google.common.primitives.UnsignedBytes;

class WriteFence
implements TransactionAware {
    private final byte[] fenceId;
    private Transaction tx;
    private Collection<byte[]> inProgressChanges;

    public WriteFence(byte[] fenceId) {
        this.fenceId = fenceId;
    }

    public void startTx(Transaction tx) {
        this.tx = tx;
        if (this.inProgressChanges == null) {
            this.inProgressChanges = new TreeSet<byte[]>(UnsignedBytes.lexicographicalComparator());
            for (long inProgressTx : tx.getInProgress()) {
                this.inProgressChanges.add(Bytes.concat(this.fenceId, Longs.toByteArray(inProgressTx)));
            }
        }
    }

    public void updateTx(Transaction tx) {
    }

    public Collection<byte[]> getTxChanges() {
        if (this.inProgressChanges == null || this.tx == null) {
            throw new IllegalStateException("Transaction has not started yet");
        }
        return this.inProgressChanges;
    }

    public boolean commitTx() throws Exception {
        return true;
    }

    public void postTxCommit() {
        this.tx = null;
    }

    public boolean rollbackTx() throws Exception {
        return true;
    }

    public String getTransactionAwareName() {
        return this.getClass().getSimpleName();
    }
}

