/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kudu;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Writer;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractSchemaFactory;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.kudu.DrillKuduTable;
import org.apache.drill.exec.store.kudu.KuduScanSpec;
import org.apache.drill.exec.store.kudu.KuduStoragePlugin;
import org.apache.drill.exec.store.kudu.KuduWriter;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ListTablesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduSchemaFactory
extends AbstractSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(KuduSchemaFactory.class);
    private final KuduStoragePlugin plugin;

    public KuduSchemaFactory(KuduStoragePlugin plugin, String name) throws IOException {
        super(name);
        this.plugin = plugin;
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        KuduTables schema = new KuduTables(this.getName());
        SchemaPlus hPlus = parent.add(this.getName(), (org.apache.calcite.schema.Schema)schema);
        schema.setHolder(hPlus);
    }

    class KuduTables
    extends AbstractSchema {
        KuduTables(String name) {
            super(Collections.emptyList(), name);
        }

        public void setHolder(SchemaPlus plusOfThis) {
        }

        public AbstractSchema getSubSchema(String name) {
            return null;
        }

        public Set<String> getSubSchemaNames() {
            return Collections.emptySet();
        }

        public Table getTable(String name) {
            KuduScanSpec scanSpec = new KuduScanSpec(name);
            try {
                KuduTable table = KuduSchemaFactory.this.plugin.getClient().openTable(name);
                Schema schema = table.getSchema();
                return new DrillKuduTable(this.getName(), KuduSchemaFactory.this.plugin, schema, scanSpec);
            }
            catch (Exception e) {
                logger.warn("Failure while retrieving kudu table {}", (Object)name, (Object)e);
                return null;
            }
        }

        public Set<String> getTableNames() {
            try {
                ListTablesResponse tablesList = KuduSchemaFactory.this.plugin.getClient().getTablesList();
                return Sets.newHashSet((Iterable)tablesList.getTablesList());
            }
            catch (Exception e) {
                logger.warn("Failure reading kudu tables.", (Throwable)e);
                return Collections.emptySet();
            }
        }

        public CreateTableEntry createNewTable(final String tableName, List<String> partitionColumns) {
            return new CreateTableEntry(){

                public Writer getWriter(PhysicalOperator child) throws IOException {
                    return new KuduWriter(child, tableName, KuduSchemaFactory.this.plugin);
                }

                public List<String> getPartitionColumns() {
                    return Collections.emptyList();
                }
            };
        }

        public void dropTable(String tableName) {
            try {
                KuduSchemaFactory.this.plugin.getClient().deleteTable(tableName);
            }
            catch (Exception e) {
                throw UserException.dataWriteError((Throwable)e).message("Failure while trying to drop table '%s'.", new Object[]{tableName}).addContext("plugin", this.name).build(logger);
            }
        }

        public boolean isMutable() {
            return true;
        }

        public String getTypeName() {
            return "kudu";
        }
    }
}

