/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.jdbc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import oadd.org.apache.calcite.DataContext;
import oadd.org.apache.calcite.jdbc.CalciteSchema;
import oadd.org.apache.calcite.jdbc.DynamicSchema;
import oadd.org.apache.calcite.linq4j.tree.Expression;
import oadd.org.apache.calcite.linq4j.tree.Expressions;
import oadd.org.apache.calcite.schema.Schema;
import oadd.org.apache.calcite.schema.SchemaPlus;
import oadd.org.apache.calcite.util.BuiltInMethod;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.exceptions.UserExceptionUtils;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.alias.AliasRegistryProvider;
import oadd.org.apache.drill.exec.planner.sql.SchemaUtilities;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.store.AbstractSchema;
import oadd.org.apache.drill.exec.store.SchemaConfig;
import oadd.org.apache.drill.exec.store.StoragePlugin;
import oadd.org.apache.drill.exec.store.StoragePluginRegistry;
import oadd.org.apache.drill.exec.store.SubSchemaWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRootSchema
extends DynamicSchema {
    private static final Logger logger = LoggerFactory.getLogger(DynamicRootSchema.class);
    private static final String ROOT_SCHEMA_NAME = "";
    private final SchemaConfig schemaConfig;
    private final StoragePluginRegistry storages;
    private final AliasRegistryProvider aliasRegistryProvider;

    DynamicRootSchema(StoragePluginRegistry storages, SchemaConfig schemaConfig, AliasRegistryProvider aliasRegistryProvider) {
        super(null, (Schema)new RootSchema(storages), ROOT_SCHEMA_NAME);
        this.schemaConfig = schemaConfig;
        this.storages = storages;
        this.aliasRegistryProvider = aliasRegistryProvider;
    }

    @Override
    protected CalciteSchema getImplicitSubSchema(String schemaName, boolean caseSensitive) {
        String actualSchemaName = this.aliasRegistryProvider.getStorageAliasesRegistry().getUserAliases(this.schemaConfig.getUserName()).get(SchemaPath.getSimplePath(schemaName).toExpr());
        return this.getSchema(actualSchemaName != null ? SchemaPath.parseFromString(actualSchemaName).getRootSegmentPath() : schemaName, caseSensitive);
    }

    private CalciteSchema getSchema(String schemaName, boolean caseSensitive) {
        schemaName = schemaName == null ? null : schemaName.toLowerCase();
        CalciteSchema retSchema = (CalciteSchema)this.subSchemaMap.map().get(schemaName);
        if (retSchema != null) {
            return retSchema;
        }
        this.loadSchemaFactory(schemaName, caseSensitive);
        retSchema = (CalciteSchema)this.subSchemaMap.map().get(schemaName);
        return retSchema;
    }

    private SchemaPath resolveTableAlias(String alias) {
        return Optional.ofNullable(this.aliasRegistryProvider.getTableAliasesRegistry().getUserAliases(this.schemaConfig.getUserName()).get(alias)).map(SchemaPath::parseFromString).orElse(null);
    }

    private void registerSchemasWithRetry(StoragePlugin plugin) throws Exception {
        long maxAttempts = 1L + this.schemaConfig.getOption((String)"storage.plugin_retry_attempts").num_val;
        long retryDelayMs = this.schemaConfig.getOption((String)"storage.plugin_retry_attempt_delay").num_val;
        int attempt = 0;
        Exception lastAttemptEx = null;
        while ((long)attempt++ < maxAttempts) {
            try {
                plugin.registerSchemas(this.schemaConfig, this.plus());
                return;
            }
            catch (Exception ex) {
                lastAttemptEx = ex;
                logger.warn("Attempt {} of {} to register schemas for plugin {} failed.", attempt, maxAttempts, plugin, ex);
                if ((long)attempt >= maxAttempts) continue;
                logger.info("Next attempt to register schemas for plugin {} will be made in {}ms.", (Object)plugin, (Object)retryDelayMs);
                try {
                    Thread.sleep(retryDelayMs);
                }
                catch (InterruptedException intEx) {
                    logger.warn("Interrupted while waiting to make another attempt to register schemas for plugin {}.", (Object)plugin, (Object)intEx);
                }
            }
        }
        throw lastAttemptEx;
    }

    private void loadSchemaFactory(String schemaName, boolean caseSensitive) {
        block12: {
            StoragePlugin plugin = null;
            try {
                SchemaPlus schemaPlus = this.plus();
                plugin = this.storages.getPlugin(schemaName);
                if (plugin != null) {
                    this.registerSchemasWithRetry(plugin);
                    return;
                }
                List paths = SchemaUtilities.getSchemaPathAsList((String)schemaName);
                if (paths.size() != 2) break block12;
                plugin = this.storages.getPlugin((String)paths.get(0));
                if (plugin == null) {
                    return;
                }
                SchemaPlus firstLevelSchema = schemaPlus.getSubSchema((String)paths.get(0));
                if (firstLevelSchema == null) {
                    this.registerSchemasWithRetry(plugin);
                    firstLevelSchema = schemaPlus.getSubSchema((String)paths.get(0));
                }
                ArrayList<SchemaPlus> secondLevelSchemas = new ArrayList<SchemaPlus>();
                for (String secondLevelSchemaName : firstLevelSchema.getSubSchemaNames()) {
                    secondLevelSchemas.add(firstLevelSchema.getSubSchema(secondLevelSchemaName));
                }
                for (SchemaPlus schema : secondLevelSchemas) {
                    AbstractSchema drillSchema;
                    try {
                        drillSchema = (AbstractSchema)schema.unwrap(AbstractSchema.class);
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException(String.format("Schema '%s' is not expected under root schema", schema.getName()));
                    }
                    SubSchemaWrapper wrapper = new SubSchemaWrapper(drillSchema);
                    schemaPlus.add(wrapper.getName(), (Schema)wrapper);
                }
            }
            catch (Exception ex) {
                UserException.Builder exceptBuilder;
                logger.error("Failed to load schema for {}", (Object)schemaName, (Object)ex);
                UserException.Builder builder = exceptBuilder = ex instanceof UserException ? ((UserException)ex).rebuild().errorType(UserBitShared.DrillPBError.ErrorType.PLUGIN) : UserException.pluginError(ex).message("Failed to load schema for schema %s", schemaName).addContext("%s: %s", ex.getClass().getName(), ex.getMessage()).addContext(UserExceptionUtils.getUserHint(ex));
                if (this.schemaConfig.getOption((String)"storage.plugin_auto_disable").bool_val.booleanValue()) {
                    String msg = String.format("The plugin %s will now be disabled (see SYSTEM option %s)", plugin.getName(), "storage.plugin_auto_disable");
                    exceptBuilder.addContext(msg);
                    logger.warn(msg);
                    try {
                        this.storages.setEnabled(plugin.getName(), false);
                    }
                    catch (StoragePluginRegistry.PluginException disableEx) {
                        logger.error("Could not disable {}", (Object)plugin.getName(), (Object)disableEx);
                    }
                }
                throw exceptBuilder.build(logger);
            }
        }
    }

    @Override
    protected CalciteSchema.TableEntry getImplicitTable(String tableName, boolean caseSensitive) {
        return Optional.ofNullable(this.getTemporaryTable(tableName, caseSensitive)).map(table -> new CalciteSchema.TableEntryImpl((CalciteSchema)this, tableName, table.getTable(), table.sqls)).orElse(super.getImplicitTable(tableName, true));
    }

    private CalciteSchema.TableEntry getTemporaryTable(String tableName, boolean caseSensitive) {
        DynamicRootSchema currentSchema = this;
        PathSegment.NameSegment pathSegment = Optional.ofNullable(this.resolveTableAlias(SchemaPath.getCompoundPath(tableName).toExpr())).map(SchemaPath::getRootSegment).orElse(null);
        if (pathSegment == null) {
            return null;
        }
        while (!pathSegment.isLastPath()) {
            currentSchema = currentSchema.getImplicitSubSchema(pathSegment.getPath(), caseSensitive);
            pathSegment = pathSegment.getChild().getNameSegment();
        }
        if (currentSchema != null) {
            return currentSchema.getTable(pathSegment.getNameSegment().getPath(), caseSensitive);
        }
        return null;
    }

    public static class RootSchema
    extends AbstractSchema {
        private final StoragePluginRegistry storages;

        public RootSchema(StoragePluginRegistry storages) {
            super(Collections.emptyList(), DynamicRootSchema.ROOT_SCHEMA_NAME);
            this.storages = storages;
        }

        public Set<String> getSubSchemaNames() {
            return this.storages.availablePlugins();
        }

        public String getTypeName() {
            return DynamicRootSchema.ROOT_SCHEMA_NAME;
        }

        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, (Expression[])new Expression[0]);
        }

        public boolean showInInformationSchema() {
            return false;
        }
    }
}

