/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.math.linear;

import oadd.org.apache.commons.math.MathRuntimeException;
import oadd.org.apache.commons.math.MaxIterationsExceededException;
import oadd.org.apache.commons.math.exception.util.LocalizedFormats;
import oadd.org.apache.commons.math.linear.ArrayRealVector;
import oadd.org.apache.commons.math.linear.DecompositionSolver;
import oadd.org.apache.commons.math.linear.EigenDecomposition;
import oadd.org.apache.commons.math.linear.InvalidMatrixException;
import oadd.org.apache.commons.math.linear.MatrixUtils;
import oadd.org.apache.commons.math.linear.RealMatrix;
import oadd.org.apache.commons.math.linear.RealVector;
import oadd.org.apache.commons.math.linear.SingularMatrixException;
import oadd.org.apache.commons.math.linear.TriDiagonalTransformer;
import oadd.org.apache.commons.math.util.FastMath;

public class EigenDecompositionImpl
implements EigenDecomposition {
    private byte maxIter = (byte)30;
    private double[] main;
    private double[] secondary;
    private TriDiagonalTransformer transformer;
    private double[] realEigenvalues;
    private double[] imagEigenvalues;
    private ArrayRealVector[] eigenvectors;
    private RealMatrix cachedV;
    private RealMatrix cachedD;
    private RealMatrix cachedVt;

    public EigenDecompositionImpl(RealMatrix matrix, double splitTolerance) throws InvalidMatrixException {
        if (!this.isSymmetric(matrix)) {
            throw new InvalidMatrixException(LocalizedFormats.ASSYMETRIC_EIGEN_NOT_SUPPORTED, new Object[0]);
        }
        this.transformToTridiagonal(matrix);
        this.findEigenVectors(this.transformer.getQ().getData());
    }

    public EigenDecompositionImpl(double[] main, double[] secondary, double splitTolerance) throws InvalidMatrixException {
        this.main = (double[])main.clone();
        this.secondary = (double[])secondary.clone();
        this.transformer = null;
        int size = main.length;
        double[][] z = new double[size][size];
        for (int i = 0; i < size; ++i) {
            z[i][i] = 1.0;
        }
        this.findEigenVectors(z);
    }

    private boolean isSymmetric(RealMatrix matrix) {
        int rows = matrix.getRowDimension();
        int columns = matrix.getColumnDimension();
        double eps = (double)(10 * rows * columns) * (double)1.110223E-16f;
        for (int i = 0; i < rows; ++i) {
            for (int j = i + 1; j < columns; ++j) {
                double mji;
                double mij = matrix.getEntry(i, j);
                if (!(FastMath.abs(mij - (mji = matrix.getEntry(j, i))) > FastMath.max(FastMath.abs(mij), FastMath.abs(mji)) * eps)) continue;
                return false;
            }
        }
        return true;
    }

    public RealMatrix getV() throws InvalidMatrixException {
        if (this.cachedV == null) {
            int m3 = this.eigenvectors.length;
            this.cachedV = MatrixUtils.createRealMatrix(m3, m3);
            for (int k = 0; k < m3; ++k) {
                this.cachedV.setColumnVector(k, this.eigenvectors[k]);
            }
        }
        return this.cachedV;
    }

    public RealMatrix getD() throws InvalidMatrixException {
        if (this.cachedD == null) {
            this.cachedD = MatrixUtils.createRealDiagonalMatrix(this.realEigenvalues);
        }
        return this.cachedD;
    }

    public RealMatrix getVT() throws InvalidMatrixException {
        if (this.cachedVt == null) {
            int m3 = this.eigenvectors.length;
            this.cachedVt = MatrixUtils.createRealMatrix(m3, m3);
            for (int k = 0; k < m3; ++k) {
                this.cachedVt.setRowVector(k, this.eigenvectors[k]);
            }
        }
        return this.cachedVt;
    }

    public double[] getRealEigenvalues() throws InvalidMatrixException {
        return (double[])this.realEigenvalues.clone();
    }

    public double getRealEigenvalue(int i) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.realEigenvalues[i];
    }

    public double[] getImagEigenvalues() throws InvalidMatrixException {
        return (double[])this.imagEigenvalues.clone();
    }

    public double getImagEigenvalue(int i) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.imagEigenvalues[i];
    }

    public RealVector getEigenvector(int i) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.eigenvectors[i].copy();
    }

    public double getDeterminant() {
        double determinant = 1.0;
        for (double lambda : this.realEigenvalues) {
            determinant *= lambda;
        }
        return determinant;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.realEigenvalues, this.imagEigenvalues, this.eigenvectors);
    }

    private void transformToTridiagonal(RealMatrix matrix) {
        this.transformer = new TriDiagonalTransformer(matrix);
        this.main = this.transformer.getMainDiagonalRef();
        this.secondary = this.transformer.getSecondaryDiagonalRef();
    }

    private void findEigenVectors(double[][] householderMatrix) {
        int i;
        double[][] z = (double[][])householderMatrix.clone();
        int n = this.main.length;
        this.realEigenvalues = new double[n];
        this.imagEigenvalues = new double[n];
        double[] e = new double[n];
        for (int i2 = 0; i2 < n - 1; ++i2) {
            this.realEigenvalues[i2] = this.main[i2];
            e[i2] = this.secondary[i2];
        }
        this.realEigenvalues[n - 1] = this.main[n - 1];
        e[n - 1] = 0.0;
        double maxAbsoluteValue = 0.0;
        for (i = 0; i < n; ++i) {
            if (FastMath.abs(this.realEigenvalues[i]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i]);
            }
            if (!(FastMath.abs(e[i]) > maxAbsoluteValue)) continue;
            maxAbsoluteValue = FastMath.abs(e[i]);
        }
        if (maxAbsoluteValue != 0.0) {
            for (i = 0; i < n; ++i) {
                if (FastMath.abs(this.realEigenvalues[i]) <= (double)1.110223E-16f * maxAbsoluteValue) {
                    this.realEigenvalues[i] = 0.0;
                }
                if (!(FastMath.abs(e[i]) <= (double)1.110223E-16f * maxAbsoluteValue)) continue;
                e[i] = 0.0;
            }
        }
        for (int j = 0; j < n; ++j) {
            int m3;
            int its = 0;
            do {
                int i3;
                for (m3 = j; m3 < n - 1; ++m3) {
                    double delta = FastMath.abs(this.realEigenvalues[m3]) + FastMath.abs(this.realEigenvalues[m3 + 1]);
                    if (FastMath.abs(e[m3]) + delta == delta) break;
                }
                if (m3 == j) continue;
                if (its == this.maxIter) {
                    throw new InvalidMatrixException(new MaxIterationsExceededException(this.maxIter));
                }
                ++its;
                double q = (this.realEigenvalues[j + 1] - this.realEigenvalues[j]) / (2.0 * e[j]);
                double t = FastMath.sqrt(1.0 + q * q);
                q = q < 0.0 ? this.realEigenvalues[m3] - this.realEigenvalues[j] + e[j] / (q - t) : this.realEigenvalues[m3] - this.realEigenvalues[j] + e[j] / (q + t);
                double u = 0.0;
                double s2 = 1.0;
                double c = 1.0;
                for (i3 = m3 - 1; i3 >= j; --i3) {
                    double p = s2 * e[i3];
                    double h2 = c * e[i3];
                    if (FastMath.abs(p) >= FastMath.abs(q)) {
                        c = q / p;
                        t = FastMath.sqrt(c * c + 1.0);
                        e[i3 + 1] = p * t;
                        s2 = 1.0 / t;
                        c *= s2;
                    } else {
                        s2 = p / q;
                        t = FastMath.sqrt(s2 * s2 + 1.0);
                        e[i3 + 1] = q * t;
                        c = 1.0 / t;
                        s2 *= c;
                    }
                    if (e[i3 + 1] == 0.0) {
                        int n2 = i3 + 1;
                        this.realEigenvalues[n2] = this.realEigenvalues[n2] - u;
                        e[m3] = 0.0;
                        break;
                    }
                    q = this.realEigenvalues[i3 + 1] - u;
                    t = (this.realEigenvalues[i3] - q) * s2 + 2.0 * c * h2;
                    u = s2 * t;
                    this.realEigenvalues[i3 + 1] = q + u;
                    q = c * t - h2;
                    for (int ia = 0; ia < n; ++ia) {
                        p = z[ia][i3 + 1];
                        z[ia][i3 + 1] = s2 * z[ia][i3] + c * p;
                        z[ia][i3] = c * z[ia][i3] - s2 * p;
                    }
                }
                if (t == 0.0 && i3 >= j) continue;
                int n3 = j;
                this.realEigenvalues[n3] = this.realEigenvalues[n3] - u;
                e[j] = q;
                e[m3] = 0.0;
            } while (m3 != j);
        }
        for (i = 0; i < n; ++i) {
            int j;
            int k = i;
            double p = this.realEigenvalues[i];
            for (j = i + 1; j < n; ++j) {
                if (!(this.realEigenvalues[j] > p)) continue;
                k = j;
                p = this.realEigenvalues[j];
            }
            if (k == i) continue;
            this.realEigenvalues[k] = this.realEigenvalues[i];
            this.realEigenvalues[i] = p;
            for (j = 0; j < n; ++j) {
                p = z[j][i];
                z[j][i] = z[j][k];
                z[j][k] = p;
            }
        }
        maxAbsoluteValue = 0.0;
        for (i = 0; i < n; ++i) {
            if (!(FastMath.abs(this.realEigenvalues[i]) > maxAbsoluteValue)) continue;
            maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i]);
        }
        if (maxAbsoluteValue != 0.0) {
            for (i = 0; i < n; ++i) {
                if (!(FastMath.abs(this.realEigenvalues[i]) < (double)1.110223E-16f * maxAbsoluteValue)) continue;
                this.realEigenvalues[i] = 0.0;
            }
        }
        this.eigenvectors = new ArrayRealVector[n];
        double[] tmp = new double[n];
        for (int i4 = 0; i4 < n; ++i4) {
            for (int j = 0; j < n; ++j) {
                tmp[j] = z[j][i4];
            }
            this.eigenvectors[i4] = new ArrayRealVector(tmp);
        }
    }

    private static class Solver
    implements DecompositionSolver {
        private double[] realEigenvalues;
        private double[] imagEigenvalues;
        private final ArrayRealVector[] eigenvectors;

        private Solver(double[] realEigenvalues, double[] imagEigenvalues, ArrayRealVector[] eigenvectors) {
            this.realEigenvalues = realEigenvalues;
            this.imagEigenvalues = imagEigenvalues;
            this.eigenvectors = eigenvectors;
        }

        public double[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m3 = this.realEigenvalues.length;
            if (b.length != m3) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.length, m3);
            }
            double[] bp = new double[m3];
            for (int i = 0; i < m3; ++i) {
                ArrayRealVector v = this.eigenvectors[i];
                double[] vData = v.getDataRef();
                double s2 = v.dotProduct(b) / this.realEigenvalues[i];
                for (int j = 0; j < m3; ++j) {
                    int n = j;
                    bp[n] = bp[n] + s2 * vData[j];
                }
            }
            return bp;
        }

        public RealVector solve(RealVector b) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m3 = this.realEigenvalues.length;
            if (b.getDimension() != m3) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.getDimension(), m3);
            }
            double[] bp = new double[m3];
            for (int i = 0; i < m3; ++i) {
                ArrayRealVector v = this.eigenvectors[i];
                double[] vData = v.getDataRef();
                double s2 = v.dotProduct(b) / this.realEigenvalues[i];
                for (int j = 0; j < m3; ++j) {
                    int n = j;
                    bp[n] = bp[n] + s2 * vData[j];
                }
            }
            return new ArrayRealVector(bp, false);
        }

        public RealMatrix solve(RealMatrix b) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m3 = this.realEigenvalues.length;
            if (b.getRowDimension() != m3) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b.getRowDimension(), b.getColumnDimension(), m3, "n");
            }
            int nColB = b.getColumnDimension();
            double[][] bp = new double[m3][nColB];
            for (int k = 0; k < nColB; ++k) {
                for (int i = 0; i < m3; ++i) {
                    int j;
                    ArrayRealVector v = this.eigenvectors[i];
                    double[] vData = v.getDataRef();
                    double s2 = 0.0;
                    for (j = 0; j < m3; ++j) {
                        s2 += v.getEntry(j) * b.getEntry(j, k);
                    }
                    s2 /= this.realEigenvalues[i];
                    for (j = 0; j < m3; ++j) {
                        double[] dArray = bp[j];
                        int n = k;
                        dArray[n] = dArray[n] + s2 * vData[j];
                    }
                }
            }
            return MatrixUtils.createRealMatrix(bp);
        }

        public boolean isNonSingular() {
            for (int i = 0; i < this.realEigenvalues.length; ++i) {
                if (this.realEigenvalues[i] != 0.0 || this.imagEigenvalues[i] != 0.0) continue;
                return false;
            }
            return true;
        }

        public RealMatrix getInverse() throws InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m3 = this.realEigenvalues.length;
            double[][] invData = new double[m3][m3];
            for (int i = 0; i < m3; ++i) {
                double[] invI = invData[i];
                for (int j = 0; j < m3; ++j) {
                    double invIJ = 0.0;
                    for (int k = 0; k < m3; ++k) {
                        double[] vK = this.eigenvectors[k].getDataRef();
                        invIJ += vK[i] * vK[j] / this.realEigenvalues[k];
                    }
                    invI[j] = invIJ;
                }
            }
            return MatrixUtils.createRealMatrix(invData);
        }
    }
}

