/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.math3.optim.nonlinear.scalar;

import oadd.org.apache.commons.math3.analysis.MultivariateFunction;
import oadd.org.apache.commons.math3.exception.TooManyEvaluationsException;
import oadd.org.apache.commons.math3.optim.BaseMultivariateOptimizer;
import oadd.org.apache.commons.math3.optim.ConvergenceChecker;
import oadd.org.apache.commons.math3.optim.OptimizationData;
import oadd.org.apache.commons.math3.optim.PointValuePair;
import oadd.org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import oadd.org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultivariateOptimizer
extends BaseMultivariateOptimizer<PointValuePair> {
    private MultivariateFunction function;
    private GoalType goal;

    protected MultivariateOptimizer(ConvergenceChecker<PointValuePair> checker) {
        super(checker);
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optData) throws TooManyEvaluationsException {
        this.parseOptimizationData(optData);
        return (PointValuePair)super.optimize(optData);
    }

    private void parseOptimizationData(OptimizationData ... optData) {
        for (OptimizationData data : optData) {
            if (data instanceof GoalType) {
                this.goal = (GoalType)data;
                continue;
            }
            if (!(data instanceof ObjectiveFunction)) continue;
            this.function = ((ObjectiveFunction)data).getObjectiveFunction();
        }
    }

    public GoalType getGoalType() {
        return this.goal;
    }

    protected double computeObjectiveValue(double[] params) {
        super.incrementEvaluationCount();
        return this.function.value(params);
    }
}

