/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import oadd.com.google.common.base.Preconditions;

public class Collectors {
    private Collectors() {
    }

    public static <T, K, V> List<T> toList(Map<K, V> map, BiFunction<K, V, T> mapper) {
        return Collectors.collect(new ArrayList(map.size()), map, mapper);
    }

    public static <T, K, V> List<T> toList(Map<K, V> map, BiFunction<K, V, T> mapper, Predicate<T> predicate) {
        return Collectors.collect(new ArrayList(map.size()), map, mapper, predicate);
    }

    public static <T, K, V> List<T> collect(List<T> list, Map<K, V> map, BiFunction<K, V, T> mapper) {
        Preconditions.checkNotNull(list);
        Preconditions.checkNotNull(map);
        Preconditions.checkNotNull(mapper);
        map.forEach((k, v) -> list.add(mapper.apply(k, v)));
        return list;
    }

    public static <T, K, V> List<T> collect(List<T> list, Map<K, V> map, BiFunction<K, V, T> mapper, Predicate<T> predicate) {
        Preconditions.checkNotNull(list);
        Preconditions.checkNotNull(map);
        Preconditions.checkNotNull(mapper);
        Preconditions.checkNotNull(predicate);
        map.forEach((k, v) -> {
            Object t = mapper.apply(k, v);
            if (predicate.test(t)) {
                list.add(t);
            }
        });
        return list;
    }

    public static <T, E> List<T> toList(Collection<E> collection, Function<E, T> mapper) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(mapper);
        ArrayList list = new ArrayList(collection.size());
        collection.forEach(e -> list.add(mapper.apply(e)));
        return list;
    }

    public static <T, E> List<T> toList(Collection<E> collection, Function<E, T> mapper, Predicate<T> predicate) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(mapper);
        Preconditions.checkNotNull(predicate);
        ArrayList list = new ArrayList(collection.size());
        collection.forEach(e -> {
            Object t = mapper.apply(e);
            if (predicate.test(t)) {
                list.add(t);
            }
        });
        return list;
    }
}

