/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.config;

import java.util.Set;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.databind.InjectableValues;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.SerializationFeature;
import oadd.com.fasterxml.jackson.databind.module.SimpleModule;
import oadd.com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.logical.FormatPluginConfig;
import oadd.org.apache.drill.common.logical.StoragePluginConfig;
import oadd.org.apache.drill.common.logical.data.LogicalOperator;
import oadd.org.apache.drill.common.logical.security.CredentialsProvider;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;
import oadd.org.apache.drill.common.util.JacksonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalPlanPersistence {
    private static final Logger logger = LoggerFactory.getLogger(LogicalPlanPersistence.class);
    private final ObjectMapper mapper;

    public LogicalPlanPersistence(DrillConfig conf, ScanResult scanResult) {
        this(conf, scanResult, JacksonUtils.createObjectMapper());
    }

    public LogicalPlanPersistence(DrillConfig conf, ScanResult scanResult, ObjectMapper mapper) {
        this.mapper = mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        SimpleModule deserModule = new SimpleModule("LogicalExpressionDeserializationModule").addDeserializer(LogicalExpression.class, new LogicalExpression.De(conf)).addDeserializer(SchemaPath.class, new SchemaPath.De());
        InjectableValues.Std injectables = new InjectableValues.Std().addValue(DrillConfig.class, (Object)conf);
        mapper.setInjectableValues(injectables);
        mapper.registerModule(deserModule);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.setFilterProvider(new SimpleFilterProvider().setFailOnUnknownId(false));
        this.registerSubtypes(LogicalPlanPersistence.getSubTypes(scanResult, LogicalOperator.class));
        this.registerSubtypes(LogicalPlanPersistence.getSubTypes(scanResult, StoragePluginConfig.class));
        this.registerSubtypes(LogicalPlanPersistence.getSubTypes(scanResult, FormatPluginConfig.class));
        this.registerSubtypes(LogicalPlanPersistence.getSubTypes(scanResult, CredentialsProvider.class));
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private <T> void registerSubtypes(Set<Class<? extends T>> types) {
        for (Class<T> clazz : types) {
            this.mapper.registerSubtypes(clazz);
        }
    }

    public static <T> Set<Class<? extends T>> getSubTypes(ScanResult classpathScan, Class<T> parent) {
        Set<Class<T>> subclasses = classpathScan.getImplementations(parent);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder().append("Found ").append(subclasses.size()).append(" ").append(parent.getSimpleName()).append(" subclasses:\n");
            for (Class<T> c : subclasses) {
                sb.append('\t');
                sb.append(c.getName());
                sb.append('\n');
            }
            logger.debug(sb.toString());
        }
        return subclasses;
    }
}

