/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.io.IOException;
import oadd.com.fasterxml.jackson.core.JsonGenerationException;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.SerializerProvider;
import oadd.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import oadd.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import oadd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import oadd.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;

@JsonSerialize(using=Se.class)
@JsonDeserialize(using=De.class)
public class FieldReference
extends SchemaPath {
    private TypeProtos.MajorType overrideType;

    public FieldReference(SchemaPath sp) {
        super(sp);
    }

    public FieldReference(CharSequence value) {
        this(value, ExpressionPosition.UNKNOWN);
    }

    public FieldReference(CharSequence value, ExpressionPosition pos) {
        super(new PathSegment.NameSegment(value), pos);
    }

    public FieldReference(String value, ExpressionPosition pos, TypeProtos.MajorType dataType) {
        this((CharSequence)value, pos);
        this.overrideType = dataType;
    }

    public static FieldReference getWithQuotedRef(CharSequence safeString) {
        return new FieldReference(safeString, ExpressionPosition.UNKNOWN);
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        if (this.overrideType == null) {
            return super.getMajorType();
        }
        return this.overrideType;
    }

    public static class Se
    extends StdSerializer<FieldReference> {
        public Se() {
            super(FieldReference.class);
        }

        @Override
        public void serialize(FieldReference value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString("`" + value.getRootSegment().getNameSegment().getPath() + "`");
        }
    }

    public static class De
    extends StdDeserializer<FieldReference> {
        public De() {
            super(FieldReference.class);
        }

        @Override
        public FieldReference deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String ref = this._parseString(jp, ctxt);
            ref = ref.replace("`", "");
            return new FieldReference((CharSequence)ref, ExpressionPosition.UNKNOWN);
        }
    }
}

