/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.logical.data;

import java.util.Iterator;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.annotation.JsonTypeName;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.node.ObjectNode;
import oadd.com.google.common.collect.Iterators;
import oadd.org.apache.drill.common.logical.data.LogicalOperator;
import oadd.org.apache.drill.common.logical.data.SingleInputOperator;
import oadd.org.apache.drill.common.logical.data.visitors.LogicalVisitor;

@JsonTypeName(value="limit")
public class Limit
extends SingleInputOperator {
    private final Integer first;
    private final Integer last;

    @JsonCreator
    public Limit(@JsonProperty(value="first") Integer first, @JsonProperty(value="last") Integer last) {
        this.first = first;
        this.last = last;
    }

    public Integer getFirst() {
        return this.first;
    }

    public Integer getLast() {
        return this.last;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitLimit(this, value);
    }

    public LogicalOperator.NodeBuilder<Limit> nodeBuilder() {
        return new LimitNodeBuilder();
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.singletonIterator(this.getInput());
    }

    public static class LimitNodeBuilder
    implements LogicalOperator.NodeBuilder<Limit> {
        @Override
        public ObjectNode convert(ObjectMapper mapper, Limit operator, Integer inputId) {
            ObjectNode limitNode = mapper.createObjectNode();
            limitNode.put("op", "limit");
            limitNode.put("input", inputId);
            limitNode.put("first", operator.first);
            limitNode.put("last", operator.last);
            return limitNode;
        }
    }
}

