/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedFieldExpr;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.fn.FuncHolder;
import oadd.org.apache.drill.common.expression.fn.FunctionReplacementUtils;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.ComparisonPredicate;
import oadd.org.apache.drill.exec.expr.DrillSimpleFunc;
import oadd.org.apache.drill.exec.expr.IsPredicate;
import oadd.org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;
import oadd.org.apache.drill.exec.expr.fn.interpreter.InterpreterEvaluator;
import oadd.org.apache.drill.exec.expr.holders.BigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.BitHolder;
import oadd.org.apache.drill.exec.expr.holders.DateHolder;
import oadd.org.apache.drill.exec.expr.holders.Float4Holder;
import oadd.org.apache.drill.exec.expr.holders.Float8Holder;
import oadd.org.apache.drill.exec.expr.holders.IntHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.expr.holders.VarDecimalHolder;
import oadd.org.apache.drill.exec.ops.UdfUtilities;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import oadd.org.apache.drill.exec.vector.ValueHolderHelper;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.StatisticsHolder;

public class StatisticsProvider<T extends Comparable<T>>
extends AbstractExprVisitor<ColumnStatistics<?>, Void, RuntimeException> {
    private final Map<SchemaPath, ColumnStatistics<?>> columnStatMap;
    private final long rowCount;
    private final UdfUtilities udfUtilities;
    private static final Map<TypeProtos.MinorType, Set<TypeProtos.MinorType>> CAST_FUNC = new EnumMap<TypeProtos.MinorType, Set<TypeProtos.MinorType>>(TypeProtos.MinorType.class);

    public StatisticsProvider(Map<SchemaPath, ColumnStatistics<?>> columnStatMap, long rowCount, UdfUtilities udfUtilities) {
        this.columnStatMap = columnStatMap;
        this.rowCount = rowCount;
        this.udfUtilities = udfUtilities;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public ColumnStatistics<?> visitUnknown(LogicalExpression e, Void value) {
        return null;
    }

    @Override
    public ColumnStatistics<?> visitTypedFieldExpr(TypedFieldExpr typedFieldExpr, Void value) {
        ColumnStatistics<?> columnStatistics = this.columnStatMap.get(typedFieldExpr.getPath().getUnIndexed());
        if (columnStatistics != null) {
            return columnStatistics;
        }
        if (typedFieldExpr.getMajorType().equals(Types.OPTIONAL_INT)) {
            return StatisticsProvider.getColumnStatistics(null, null, this.rowCount, typedFieldExpr.getMajorType().getMinorType());
        }
        return null;
    }

    @Override
    public ColumnStatistics<Integer> visitIntConstant(ValueExpressions.IntExpression expr, Void value) {
        return StatisticsProvider.getConstantColumnStatistics(Integer.valueOf(expr.getInt()), expr);
    }

    @Override
    public ColumnStatistics<Boolean> visitBooleanConstant(ValueExpressions.BooleanExpression expr, Void value) {
        return StatisticsProvider.getConstantColumnStatistics(Boolean.valueOf(expr.getBoolean()), expr);
    }

    @Override
    public ColumnStatistics<Long> visitLongConstant(ValueExpressions.LongExpression expr, Void value) {
        return StatisticsProvider.getConstantColumnStatistics(Long.valueOf(expr.getLong()), expr);
    }

    @Override
    public ColumnStatistics<Float> visitFloatConstant(ValueExpressions.FloatExpression expr, Void value) {
        return StatisticsProvider.getConstantColumnStatistics(Float.valueOf(expr.getFloat()), expr);
    }

    @Override
    public ColumnStatistics<Double> visitDoubleConstant(ValueExpressions.DoubleExpression expr, Void value) {
        return StatisticsProvider.getConstantColumnStatistics(Double.valueOf(expr.getDouble()), expr);
    }

    @Override
    public ColumnStatistics<Long> visitDateConstant(ValueExpressions.DateExpression expr, Void value) {
        return StatisticsProvider.getConstantColumnStatistics(Long.valueOf(expr.getDate()), expr);
    }

    @Override
    public ColumnStatistics<Long> visitTimeStampConstant(ValueExpressions.TimeStampExpression expr, Void value) {
        return StatisticsProvider.getConstantColumnStatistics(Long.valueOf(expr.getTimeStamp()), expr);
    }

    @Override
    public ColumnStatistics<Integer> visitTimeConstant(ValueExpressions.TimeExpression expr, Void value) {
        return StatisticsProvider.getConstantColumnStatistics(Integer.valueOf(expr.getTime()), expr);
    }

    @Override
    public ColumnStatistics<String> visitQuotedStringConstant(ValueExpressions.QuotedString expr, Void value) {
        return StatisticsProvider.getConstantColumnStatistics(expr.getString(), expr);
    }

    @Override
    public ColumnStatistics<BigInteger> visitVarDecimalConstant(ValueExpressions.VarDecimalExpression expr, Void value) {
        return StatisticsProvider.getConstantColumnStatistics(expr.getBigDecimal().unscaledValue(), expr);
    }

    @Override
    public ColumnStatistics<?> visitFunctionHolderExpression(FunctionHolderExpression holderExpr, Void value) {
        ColumnStatistics stat;
        FuncHolder funcHolder = holderExpr.getHolder();
        if (!(funcHolder instanceof DrillSimpleFuncHolder)) {
            return null;
        }
        String funcName = ((DrillSimpleFuncHolder)funcHolder).getRegisteredNames()[0];
        if (FunctionReplacementUtils.isCastFunction(funcName) && !IsPredicate.isNullOrEmpty(stat = (ColumnStatistics)((LogicalExpression)holderExpr.args.get(0)).accept(this, null))) {
            return this.evalCastFunc(holderExpr, stat);
        }
        return null;
    }

    private ColumnStatistics<?> evalCastFunc(FunctionHolderExpression holderExpr, ColumnStatistics<T> input) {
        try {
            ValueHolder maxHolder;
            ValueHolder minHolder;
            TypeProtos.MinorType destType;
            Comparable minValue = (Comparable)ComparisonPredicate.getMinValue(input);
            Comparable maxValue = (Comparable)ComparisonPredicate.getMaxValue(input);
            if (minValue == null && maxValue == null) {
                return input;
            }
            TypeProtos.MinorType srcType = ((LogicalExpression)holderExpr.args.get(0)).getMajorType().getMinorType();
            if (srcType.equals(destType = holderExpr.getMajorType().getMinorType())) {
                return input;
            }
            if (!CAST_FUNC.containsKey(srcType) || !CAST_FUNC.get(srcType).contains(destType)) {
                return null;
            }
            switch (srcType) {
                case INT: {
                    minHolder = ValueHolderHelper.getIntHolder((Integer)minValue);
                    maxHolder = ValueHolderHelper.getIntHolder((Integer)maxValue);
                    break;
                }
                case BIGINT: {
                    minHolder = ValueHolderHelper.getBigIntHolder((Long)minValue);
                    maxHolder = ValueHolderHelper.getBigIntHolder((Long)maxValue);
                    break;
                }
                case FLOAT4: {
                    minHolder = ValueHolderHelper.getFloat4Holder(((Float)minValue).floatValue());
                    maxHolder = ValueHolderHelper.getFloat4Holder(((Float)maxValue).floatValue());
                    break;
                }
                case FLOAT8: {
                    minHolder = ValueHolderHelper.getFloat8Holder((Double)minValue);
                    maxHolder = ValueHolderHelper.getFloat8Holder((Double)maxValue);
                    break;
                }
                case DATE: {
                    minHolder = ValueHolderHelper.getDateHolder((Long)minValue);
                    maxHolder = ValueHolderHelper.getDateHolder((Long)maxValue);
                    break;
                }
                case VARCHAR: {
                    minHolder = ValueHolderHelper.getVarCharHolder(this.udfUtilities.getManagedBuffer(), (String)((Object)minValue));
                    maxHolder = ValueHolderHelper.getVarCharHolder(this.udfUtilities.getManagedBuffer(), (String)((Object)maxValue));
                    break;
                }
                default: {
                    return null;
                }
            }
            Object[] args1 = new ValueHolder[]{minHolder};
            Object[] args2 = new ValueHolder[]{maxHolder};
            DrillSimpleFuncHolder funcHolder = (DrillSimpleFuncHolder)holderExpr.getHolder();
            DrillSimpleFunc interpreter = funcHolder.createInterpreter();
            ValueHolder minFuncHolder = InterpreterEvaluator.evaluateFunction((DrillSimpleFunc)interpreter, (Object[])args1, (String)holderExpr.getName());
            ValueHolder maxFuncHolder = InterpreterEvaluator.evaluateFunction((DrillSimpleFunc)interpreter, (Object[])args2, (String)holderExpr.getName());
            switch (destType) {
                case BIT: {
                    return StatisticsProvider.getColumnStatistics(((BitHolder)minFuncHolder).value, ((BitHolder)maxFuncHolder).value, (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(input), destType);
                }
                case INT: {
                    return StatisticsProvider.getColumnStatistics(((IntHolder)minFuncHolder).value, ((IntHolder)maxFuncHolder).value, (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(input), destType);
                }
                case BIGINT: {
                    return StatisticsProvider.getColumnStatistics(((BigIntHolder)minFuncHolder).value, ((BigIntHolder)maxFuncHolder).value, (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(input), destType);
                }
                case FLOAT4: {
                    return StatisticsProvider.getColumnStatistics(Float.valueOf(((Float4Holder)minFuncHolder).value), Float.valueOf(((Float4Holder)maxFuncHolder).value), (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(input), destType);
                }
                case FLOAT8: {
                    return StatisticsProvider.getColumnStatistics(((Float8Holder)minFuncHolder).value, ((Float8Holder)maxFuncHolder).value, (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(input), destType);
                }
                case DATE: {
                    return StatisticsProvider.getColumnStatistics(((DateHolder)minFuncHolder).value, ((DateHolder)maxFuncHolder).value, (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(input), destType);
                }
                case TIME: {
                    return StatisticsProvider.getColumnStatistics(((TimeHolder)minFuncHolder).value, ((TimeHolder)maxFuncHolder).value, (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(input), destType);
                }
                case TIMESTAMP: {
                    return StatisticsProvider.getColumnStatistics(((TimeStampHolder)minFuncHolder).value, ((TimeStampHolder)maxFuncHolder).value, (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(input), destType);
                }
                case VARDECIMAL: {
                    VarDecimalHolder minVarDecimalHolder = (VarDecimalHolder)minFuncHolder;
                    VarDecimalHolder maxVarDecimalHolder = (VarDecimalHolder)maxFuncHolder;
                    return StatisticsProvider.getColumnStatistics(DecimalUtility.getBigDecimalFromDrillBuf(minVarDecimalHolder.buffer, minVarDecimalHolder.start, minVarDecimalHolder.scale, minVarDecimalHolder.precision), DecimalUtility.getBigDecimalFromDrillBuf(maxVarDecimalHolder.buffer, maxVarDecimalHolder.start, maxVarDecimalHolder.scale, maxVarDecimalHolder.precision), (Long)ColumnStatisticsKind.NULLS_COUNT.getFrom(input), destType);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Error in evaluating function of " + holderExpr.getName());
        }
    }

    public static <V> ColumnStatistics<V> getColumnStatistics(V minVal, V maxVal, long nullsCount, TypeProtos.MinorType type) {
        return new ColumnStatistics(Arrays.asList(new StatisticsHolder(minVal, (BaseStatisticsKind)ColumnStatisticsKind.MIN_VALUE), new StatisticsHolder(maxVal, (BaseStatisticsKind)ColumnStatisticsKind.MAX_VALUE), new StatisticsHolder((Object)nullsCount, (BaseStatisticsKind)ColumnStatisticsKind.NULLS_COUNT)), type);
    }

    public static <V> ColumnStatistics<V> getConstantColumnStatistics(V minMaxValue, LogicalExpression expr) {
        return StatisticsProvider.getConstantColumnStatistics(minMaxValue, expr.getMajorType().getMinorType());
    }

    public static <V> ColumnStatistics<V> getConstantColumnStatistics(V minMaxValue, TypeProtos.MinorType type) {
        return StatisticsProvider.getColumnStatistics(minMaxValue, minMaxValue, 0L, type);
    }

    static {
        EnumSet<TypeProtos.MinorType> float4Types = EnumSet.noneOf(TypeProtos.MinorType.class);
        CAST_FUNC.put(TypeProtos.MinorType.FLOAT4, float4Types);
        float4Types.add(TypeProtos.MinorType.FLOAT8);
        float4Types.add(TypeProtos.MinorType.INT);
        float4Types.add(TypeProtos.MinorType.BIGINT);
        EnumSet<TypeProtos.MinorType> float8Types = EnumSet.noneOf(TypeProtos.MinorType.class);
        CAST_FUNC.put(TypeProtos.MinorType.FLOAT8, float8Types);
        float8Types.add(TypeProtos.MinorType.FLOAT4);
        float8Types.add(TypeProtos.MinorType.INT);
        float8Types.add(TypeProtos.MinorType.BIGINT);
        EnumSet<TypeProtos.MinorType> intTypes = EnumSet.noneOf(TypeProtos.MinorType.class);
        CAST_FUNC.put(TypeProtos.MinorType.INT, intTypes);
        intTypes.add(TypeProtos.MinorType.FLOAT4);
        intTypes.add(TypeProtos.MinorType.FLOAT8);
        intTypes.add(TypeProtos.MinorType.BIGINT);
        EnumSet<TypeProtos.MinorType> bigIntTypes = EnumSet.noneOf(TypeProtos.MinorType.class);
        CAST_FUNC.put(TypeProtos.MinorType.BIGINT, bigIntTypes);
        bigIntTypes.add(TypeProtos.MinorType.INT);
        bigIntTypes.add(TypeProtos.MinorType.FLOAT4);
        bigIntTypes.add(TypeProtos.MinorType.FLOAT8);
        EnumSet<TypeProtos.MinorType> dateTypes = EnumSet.noneOf(TypeProtos.MinorType.class);
        CAST_FUNC.put(TypeProtos.MinorType.DATE, dateTypes);
        dateTypes.add(TypeProtos.MinorType.TIMESTAMP);
    }
}

