/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.memory;

import oadd.io.netty.buffer.AbstractByteBufAllocator;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.CompositeByteBuf;
import oadd.io.netty.buffer.ExpandableByteBuf;
import oadd.io.netty.buffer.PooledByteBufAllocatorL;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;

public class DrillByteBufAllocator
extends AbstractByteBufAllocator {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int DEFAULT_MAX_COMPOSITE_COMPONENTS = 16;
    private static final PooledByteBufAllocatorL HEAP_ALLOCATOR = AllocationManager.INNER_ALLOCATOR;
    private final BufferAllocator allocator;

    public DrillByteBufAllocator(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public ByteBuf buffer() {
        return this.buffer(4096);
    }

    @Override
    public ByteBuf buffer(int initialCapacity) {
        return new ExpandableByteBuf(this.allocator.buffer(initialCapacity), this.allocator);
    }

    @Override
    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return this.buffer(initialCapacity);
    }

    @Override
    public ByteBuf ioBuffer() {
        return this.buffer();
    }

    @Override
    public ByteBuf ioBuffer(int initialCapacity) {
        return this.buffer(initialCapacity);
    }

    @Override
    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return this.buffer(initialCapacity);
    }

    @Override
    public ByteBuf directBuffer() {
        return this.buffer();
    }

    @Override
    public ByteBuf directBuffer(int initialCapacity) {
        return this.allocator.buffer(initialCapacity);
    }

    @Override
    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return this.buffer(initialCapacity, maxCapacity);
    }

    @Override
    public CompositeByteBuf compositeBuffer() {
        return this.compositeBuffer(16);
    }

    @Override
    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        return new CompositeByteBuf(this, true, maxNumComponents);
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer() {
        return this.compositeBuffer();
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return this.compositeBuffer(maxNumComponents);
    }

    @Override
    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        return HEAP_ALLOCATOR.allocateHeap(initialCapacity, maxCapacity);
    }

    @Override
    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        return this.buffer(initialCapacity, maxCapacity);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return false;
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer() {
        return this.compositeHeapBuffer(16);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return new CompositeByteBuf(this, false, maxNumComponents);
    }
}

