/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metastore.analyze;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import oadd.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.metastore.metadata.MetadataType;

@JsonDeserialize(builder=MetadataAggregateContextBuilder.class)
public class MetadataAggregateContext {
    private final List<NamedExpression> groupByExpressions;
    private final List<SchemaPath> interestingColumns;
    private final List<SchemaPath> metadataColumns;
    private final boolean createNewAggregations;
    private final MetadataType metadataLevel;

    public MetadataAggregateContext(MetadataAggregateContextBuilder builder) {
        this.groupByExpressions = builder.groupByExpressions;
        this.interestingColumns = builder.interestingColumns;
        this.createNewAggregations = builder.createNewAggregations;
        this.metadataColumns = builder.metadataColumns;
        this.metadataLevel = builder.metadataLevel;
    }

    @JsonProperty
    public List<NamedExpression> groupByExpressions() {
        return this.groupByExpressions;
    }

    @JsonProperty
    public List<SchemaPath> interestingColumns() {
        return this.interestingColumns;
    }

    @JsonProperty
    public boolean createNewAggregations() {
        return this.createNewAggregations;
    }

    @JsonProperty
    public List<SchemaPath> metadataColumns() {
        return this.metadataColumns;
    }

    @JsonProperty
    public MetadataType metadataLevel() {
        return this.metadataLevel;
    }

    public String toString() {
        return new StringJoiner(",\n", MetadataAggregateContext.class.getSimpleName() + "[", "]").add("groupByExpressions=" + String.valueOf(this.groupByExpressions)).add("interestingColumns=" + String.valueOf(this.interestingColumns)).add("createNewAggregations=" + this.createNewAggregations).add("excludedColumns=" + String.valueOf(this.metadataColumns)).toString();
    }

    public static MetadataAggregateContextBuilder builder() {
        return new MetadataAggregateContextBuilder();
    }

    public MetadataAggregateContextBuilder toBuilder() {
        return new MetadataAggregateContextBuilder().groupByExpressions(this.groupByExpressions).interestingColumns(this.interestingColumns).createNewAggregations(this.createNewAggregations).metadataColumns(this.metadataColumns).metadataLevel(this.metadataLevel);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class MetadataAggregateContextBuilder {
        private List<NamedExpression> groupByExpressions;
        private List<SchemaPath> interestingColumns;
        private Boolean createNewAggregations;
        private MetadataType metadataLevel;
        private List<SchemaPath> metadataColumns;

        public MetadataAggregateContextBuilder groupByExpressions(List<NamedExpression> groupByExpressions) {
            this.groupByExpressions = groupByExpressions;
            return this;
        }

        public MetadataAggregateContextBuilder metadataLevel(MetadataType metadataLevel) {
            this.metadataLevel = metadataLevel;
            return this;
        }

        public MetadataAggregateContextBuilder interestingColumns(List<SchemaPath> interestingColumns) {
            this.interestingColumns = interestingColumns;
            return this;
        }

        public MetadataAggregateContextBuilder createNewAggregations(boolean createNewAggregations) {
            this.createNewAggregations = createNewAggregations;
            return this;
        }

        public MetadataAggregateContextBuilder metadataColumns(List<SchemaPath> metadataColumns) {
            this.metadataColumns = metadataColumns;
            return this;
        }

        public MetadataAggregateContext build() {
            Objects.requireNonNull(this.groupByExpressions, "groupByExpressions were not set");
            Objects.requireNonNull(this.createNewAggregations, "createNewAggregations was not set");
            Objects.requireNonNull(this.metadataColumns, "metadataColumns were not set");
            Objects.requireNonNull(this.metadataLevel, "metadataLevel was not set");
            return new MetadataAggregateContext(this);
        }
    }
}

