/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metastore.store.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import oadd.org.apache.drill.exec.metastore.MetadataProviderManager;
import oadd.org.apache.drill.exec.metastore.store.parquet.ParquetTableMetadataProvider;
import oadd.org.apache.drill.exec.metastore.store.parquet.ParquetTableMetadataProviderBuilder;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import oadd.org.apache.drill.exec.store.dfs.FileSelection;
import oadd.org.apache.drill.exec.store.dfs.MetadataContext;
import oadd.org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import oadd.org.apache.drill.exec.store.parquet.BaseParquetMetadataProvider;
import oadd.org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import oadd.org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import oadd.org.apache.drill.exec.store.parquet.metadata.Metadata;
import oadd.org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import oadd.org.apache.drill.exec.util.DrillFileSystemUtil;
import oadd.org.apache.drill.exec.util.ImpersonationUtil;
import oadd.org.apache.hadoop.fs.FileStatus;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetTableMetadataProviderImpl
extends BaseParquetMetadataProvider
implements ParquetTableMetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(ParquetTableMetadataProviderImpl.class);
    private final DrillFileSystem fs;
    private final MetadataContext metaContext;
    private Path selectionRoot;
    private Path cacheFileRoot;
    private final boolean corruptDatesAutoCorrected;
    private boolean usedMetadataCache;

    private ParquetTableMetadataProviderImpl(Builder builder) throws IOException {
        super((BaseParquetMetadataProvider.Builder)builder);
        BaseParquetMetadataProvider source = (BaseParquetMetadataProvider)builder.metadataProviderManager().getTableMetadataProvider();
        this.fs = builder.fs;
        if (builder.entries() != null) {
            this.selectionRoot = builder.selectionRoot();
            this.cacheFileRoot = builder.cacheFileRoot;
            this.metaContext = new MetadataContext();
            this.corruptDatesAutoCorrected = builder.autoCorrectCorruptedDates;
            this.init(source);
        } else {
            this.selectionRoot = builder.selection().getSelectionRoot();
            this.cacheFileRoot = builder.selection().getCacheFileRoot();
            MetadataContext metadataContext = builder.selection().getMetaContext();
            this.metaContext = metadataContext != null ? metadataContext : new MetadataContext();
            this.corruptDatesAutoCorrected = builder.autoCorrectCorruptedDates;
            FileSelection fileSelection = this.expandIfNecessary(builder.selection());
            if (fileSelection != null) {
                if (this.checkForInitializingEntriesWithSelectionRoot()) {
                    this.entries.add(new ReadEntryWithPath(fileSelection.getSelectionRoot()));
                } else {
                    for (Path fileName : fileSelection.getFiles()) {
                        this.entries.add(new ReadEntryWithPath(fileName));
                    }
                }
                this.init(source);
            }
        }
        if (source == null || source.getRowGroupsMeta().size() < this.getRowGroupsMeta().size()) {
            builder.metadataProviderManager().setTableMetadataProvider(this);
        }
    }

    @Override
    public boolean isUsedMetadataCache() {
        return this.usedMetadataCache;
    }

    @Override
    public Path getSelectionRoot() {
        return this.selectionRoot;
    }

    public List<Path> populateMetaPaths(Path p, DrillFileSystem fs) throws IOException {
        if (fs.isDirectory(p)) {
            List<Path> metaFilepaths = Arrays.stream(Metadata.CURRENT_METADATA_FILENAMES).map(filename -> new Path(p, (String)filename)).collect(Collectors.toList());
            for (String filename2 : Metadata.OLD_METADATA_FILENAMES) {
                if (this.fileExists(fs, metaFilepaths)) {
                    return metaFilepaths;
                }
                metaFilepaths.clear();
                metaFilepaths.add(new Path(p, filename2));
            }
            if (this.fileExists(fs, metaFilepaths)) {
                return metaFilepaths;
            }
        }
        return Collections.emptyList();
    }

    public boolean fileExists(DrillFileSystem fs, List<Path> paths) throws IOException {
        for (Path path : paths) {
            if (fs.exists(path)) continue;
            return false;
        }
        return true;
    }

    protected void initInternal() throws IOException {
        try (DrillFileSystem processUserFileSystem = ImpersonationUtil.createFileSystem(ImpersonationUtil.getProcessUserName(), this.fs.getConf());){
            List<Object> metaPaths = new ArrayList();
            if (this.entries.size() == 1 && this.parquetTableMetadata == null) {
                Path p = Path.getPathWithoutSchemeAndAuthority(((ReadEntryWithPath)this.entries.get(0)).getPath());
                if (this.fs.isDirectory(p)) {
                    metaPaths = this.populateMetaPaths(p, this.fs);
                }
                if (!this.metaContext.isMetadataCacheCorrupted() && !metaPaths.isEmpty()) {
                    this.parquetTableMetadata = Metadata.readBlockMeta((FileSystem)processUserFileSystem, metaPaths, (MetadataContext)this.metaContext, (ParquetReaderConfig)this.readerConfig);
                    if (this.parquetTableMetadata != null) {
                        this.usedMetadataCache = true;
                    }
                }
                if (!this.usedMetadataCache) {
                    this.parquetTableMetadata = Metadata.getParquetTableMetadata((FileSystem)processUserFileSystem, (Path)p, (ParquetReaderConfig)this.readerConfig);
                }
            } else {
                Path p = Path.getPathWithoutSchemeAndAuthority(this.selectionRoot);
                metaPaths = this.populateMetaPaths(p, this.fs);
                if (!this.metaContext.isMetadataCacheCorrupted() && this.fs.isDirectory(this.selectionRoot) && !metaPaths.isEmpty()) {
                    if (this.parquetTableMetadata == null) {
                        this.parquetTableMetadata = Metadata.readBlockMeta((FileSystem)processUserFileSystem, metaPaths, (MetadataContext)this.metaContext, (ParquetReaderConfig)this.readerConfig);
                    }
                    if (this.parquetTableMetadata != null) {
                        this.usedMetadataCache = true;
                        if (this.fileSet != null) {
                            this.parquetTableMetadata = this.removeUnneededRowGroups(this.parquetTableMetadata);
                        }
                    }
                }
                if (!this.usedMetadataCache) {
                    ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>();
                    for (ReadEntryWithPath entry : this.entries) {
                        fileStatuses.addAll(DrillFileSystemUtil.listFiles((FileSystem)this.fs, Path.getPathWithoutSchemeAndAuthority(entry.getPath()), true, new PathFilter[0]));
                    }
                    Map statusMap = fileStatuses.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ParquetTableMetadataProviderImpl.lambda$initInternal$1((FileSystem)processUserFileSystem, arg_0), (oldFs, newFs) -> newFs, LinkedHashMap::new));
                    this.parquetTableMetadata = Metadata.getParquetTableMetadata((Map)statusMap, (ParquetReaderConfig)this.readerConfig);
                }
            }
        }
    }

    private FileSelection expandIfNecessary(FileSelection selection) throws IOException {
        if (selection.isExpandedFully()) {
            return selection;
        }
        Path path = this.cacheFileRoot != null ? this.cacheFileRoot : this.selectionRoot;
        List<Path> metaPaths = this.populateMetaPaths(path, this.fs);
        if (metaPaths.isEmpty()) {
            if (selection.isExpandedPartial()) {
                logger.error("'{}' metadata file/files does not exist, but metadata directories cache file is present", (Object)metaPaths.toString());
                this.metaContext.setMetadataCacheCorrupted(true);
            }
            return selection;
        }
        return this.expandSelectionFromMetadataCache(selection, metaPaths);
    }

    private boolean checkForInitializingEntriesWithSelectionRoot() {
        return this.metaContext.isMetadataCacheCorrupted() || this.parquetTableMetadata != null && (this.metaContext.getPruneStatus() == MetadataContext.PruneStatus.NOT_STARTED || this.metaContext.getPruneStatus() == MetadataContext.PruneStatus.NOT_PRUNED);
    }

    private FileSelection expandSelectionFromMetadataCache(FileSelection selection, List<Path> metaFilePaths) throws IOException {
        Path metaRootPath;
        DrillFileSystem processUserFileSystem = ImpersonationUtil.createFileSystem(ImpersonationUtil.getProcessUserName(), this.fs.getConf());
        this.parquetTableMetadata = Metadata.readBlockMeta((FileSystem)processUserFileSystem, metaFilePaths, (MetadataContext)this.metaContext, (ParquetReaderConfig)this.readerConfig);
        if (this.ignoreExpandingSelection(this.parquetTableMetadata)) {
            return selection;
        }
        if (this.corruptDatesAutoCorrected) {
            ParquetReaderUtility.correctDatesInMetadataCache((MetadataBase.ParquetTableMetadataBase)this.parquetTableMetadata);
        }
        ParquetReaderUtility.transformBinaryInMetadataCache((MetadataBase.ParquetTableMetadataBase)this.parquetTableMetadata, (ParquetReaderConfig)this.readerConfig);
        List fileStatuses = selection.getStatuses(this.fs);
        if (this.fileSet == null) {
            this.fileSet = new HashSet();
        }
        Path first = ((FileStatus)fileStatuses.get(0)).getPath();
        if (fileStatuses.size() == 1 && selection.getSelectionRoot().equals(first)) {
            for (MetadataBase.ParquetFileMetadata file : this.parquetTableMetadata.getFiles()) {
                this.fileSet.add(file.getPath());
            }
        } else if (selection.isExpandedPartial() && !selection.hadWildcard() && this.cacheFileRoot != null) {
            if (selection.wasAllPartitionsPruned()) {
                this.fileSet.add(((MetadataBase.ParquetFileMetadata)this.parquetTableMetadata.getFiles().get(0)).getPath());
            } else {
                for (MetadataBase.ParquetFileMetadata file : this.parquetTableMetadata.getFiles()) {
                    this.fileSet.add(file.getPath());
                }
            }
        } else {
            for (FileStatus status : fileStatuses) {
                Path currentCacheFileRoot = status.getPath();
                if (status.isDirectory()) {
                    List<Path> metaPaths = this.populateMetaPaths(currentCacheFileRoot, this.fs);
                    MetadataBase.ParquetTableMetadataBase metadata = Metadata.readBlockMeta((FileSystem)processUserFileSystem, metaPaths, (MetadataContext)this.metaContext, (ParquetReaderConfig)this.readerConfig);
                    if (this.ignoreExpandingSelection(metadata)) {
                        return selection;
                    }
                    for (MetadataBase.ParquetFileMetadata file : metadata.getFiles()) {
                        this.fileSet.add(file.getPath());
                    }
                    continue;
                }
                Path path = Path.getPathWithoutSchemeAndAuthority(currentCacheFileRoot);
                this.fileSet.add(path);
            }
        }
        if (this.fileSet.isEmpty()) {
            logger.warn("The table is empty but with outdated invalid metadata cache files. Please, delete them.");
            return null;
        }
        ArrayList fileNames = new ArrayList(this.fileSet);
        this.selectionRoot = metaRootPath = Path.getPathWithoutSchemeAndAuthority(selection.getSelectionRoot());
        FileSelection newSelection = new FileSelection(selection.getStatuses(this.fs), fileNames, metaRootPath, this.cacheFileRoot, selection.wasAllPartitionsPruned());
        newSelection.setExpandedFully();
        newSelection.setMetaContext(this.metaContext);
        return newSelection;
    }

    private MetadataBase.ParquetTableMetadataBase removeUnneededRowGroups(MetadataBase.ParquetTableMetadataBase parquetTableMetadata) {
        ArrayList<MetadataBase.ParquetFileMetadata> newFileMetadataList = new ArrayList<MetadataBase.ParquetFileMetadata>();
        for (MetadataBase.ParquetFileMetadata file : parquetTableMetadata.getFiles()) {
            if (!this.fileSet.contains(file.getPath())) continue;
            newFileMetadataList.add(file);
        }
        MetadataBase.ParquetTableMetadataBase metadata = parquetTableMetadata.clone();
        metadata.assignFiles(newFileMetadataList);
        return metadata;
    }

    private boolean ignoreExpandingSelection(MetadataBase.ParquetTableMetadataBase metadata) {
        if (metadata == null || this.metaContext.isMetadataCacheCorrupted()) {
            logger.debug("Selection can't be expanded since metadata file is corrupted or metadata version is not supported");
            this.parquetTableMetadata = null;
            this.fileSet = null;
            return true;
        }
        return false;
    }

    private static /* synthetic */ FileSystem lambda$initInternal$1(FileSystem processUserFileSystem, FileStatus s2) {
        return processUserFileSystem;
    }

    public static class Builder
    extends BaseParquetMetadataProvider.Builder<Builder>
    implements ParquetTableMetadataProviderBuilder<Builder> {
        private Path cacheFileRoot;
        private DrillFileSystem fs;
        private boolean autoCorrectCorruptedDates;

        public Builder(MetadataProviderManager source) {
            super(source);
        }

        @Override
        public Builder withCacheFileRoot(Path cacheFileRoot) {
            this.cacheFileRoot = cacheFileRoot;
            return this;
        }

        @Override
        public Builder withFileSystem(DrillFileSystem fs) {
            this.fs = fs;
            return this;
        }

        @Override
        public Builder withCorrectCorruptedDates(boolean autoCorrectCorruptedDates) {
            this.autoCorrectCorruptedDates = autoCorrectCorruptedDates;
            return this;
        }

        protected Builder self() {
            return this;
        }

        @Override
        public ParquetTableMetadataProvider build() throws IOException {
            return new ParquetTableMetadataProviderImpl(this);
        }
    }
}

