/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metrics;

import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import oadd.com.codahale.metrics.Metric;
import oadd.com.codahale.metrics.MetricFilter;
import oadd.com.codahale.metrics.MetricRegistry;
import oadd.com.codahale.metrics.Slf4jReporter;
import oadd.com.codahale.metrics.jmx.JmxReporter;
import oadd.com.codahale.metrics.jvm.BufferPoolMetricSet;
import oadd.com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import oadd.com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import oadd.com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import oadd.com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import oadd.com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import oadd.com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import oadd.org.apache.drill.exec.metrics.CpuGaugeSet;
import oadd.org.apache.drill.exec.util.SystemPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DrillMetrics {
    private static final Logger logger = LoggerFactory.getLogger(DrillMetrics.class);
    public static final boolean METRICS_JMX_OUTPUT_ENABLED = SystemPropertyUtil.getBoolean("drill.metrics.jmx.enabled", true);
    public static final boolean METRICS_LOG_OUTPUT_ENABLED = SystemPropertyUtil.getBoolean("drill.metrics.log.enabled", false);
    public static final int METRICS_LOG_OUTPUT_INTERVAL = SystemPropertyUtil.getInt("drill.metrics.log.interval", 60);

    public static synchronized <T extends Metric> void register(String name, T metric) {
        boolean removed = RegistryHolder.REGISTRY.remove(name);
        if (removed) {
            logger.warn("Removing old metric since name matched newly registered metric. Metric name: {}", (Object)name);
        }
        RegistryHolder.REGISTRY.register(name, metric);
    }

    public static MetricRegistry getRegistry() {
        return RegistryHolder.REGISTRY;
    }

    public static void resetMetrics() {
        RegistryHolder.REGISTRY.removeMatching(MetricFilter.ALL);
        RegistryHolder.registerSystemMetrics();
    }

    private DrillMetrics() {
    }

    private static class RegistryHolder {
        private static final MetricRegistry REGISTRY = new MetricRegistry();

        private RegistryHolder() {
        }

        private static void registerSystemMetrics() {
            REGISTRY.registerAll(new GarbageCollectorMetricSet());
            REGISTRY.registerAll("jvm", new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
            REGISTRY.registerAll("memory", new MemoryUsageGaugeSet());
            REGISTRY.registerAll("threads", new ThreadStatesGaugeSet());
            REGISTRY.registerAll("cached-threads", new CachedThreadStatesGaugeSet(1L, TimeUnit.MINUTES));
            REGISTRY.registerAll("class", new ClassLoadingGaugeSet());
            REGISTRY.registerAll(new CpuGaugeSet());
            DrillMetrics.register("fd.usage", new FileDescriptorRatioGauge());
        }

        private static JmxReporter getJmxReporter() {
            if (METRICS_JMX_OUTPUT_ENABLED) {
                JmxReporter reporter = JmxReporter.forRegistry(REGISTRY).build();
                reporter.start();
                return reporter;
            }
            return null;
        }

        private static Slf4jReporter getLogReporter() {
            if (METRICS_LOG_OUTPUT_ENABLED) {
                Slf4jReporter reporter = Slf4jReporter.forRegistry(REGISTRY).outputTo(logger).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                reporter.start(METRICS_LOG_OUTPUT_INTERVAL, TimeUnit.SECONDS);
                return reporter;
            }
            return null;
        }

        static {
            RegistryHolder.registerSystemMetrics();
            RegistryHolder.getJmxReporter();
            RegistryHolder.getLogReporter();
        }
    }
}

