/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.oauth;

import oadd.org.apache.commons.lang3.StringUtils;
import oadd.org.apache.drill.common.AutoCloseables;
import oadd.org.apache.drill.exec.oauth.PersistentTokenRegistry;
import oadd.org.apache.drill.exec.oauth.TokenRegistry;
import oadd.org.apache.drill.exec.server.DrillbitContext;

public class OAuthTokenProvider
implements AutoCloseable {
    private static final String STORAGE_REGISTRY_PATH = "oauth_tokens";
    private final DrillbitContext context;
    private PersistentTokenRegistry oauthTokenRegistry;

    public OAuthTokenProvider(DrillbitContext context) {
        this.context = context;
    }

    public TokenRegistry getOauthTokenRegistry(String username) {
        if (this.oauthTokenRegistry == null) {
            this.initRemoteRegistries(username);
        }
        return this.oauthTokenRegistry;
    }

    private synchronized void initRemoteRegistries(String username) {
        Object finalpath = StringUtils.isNotEmpty(username) ? "oauth_tokens/" + username : STORAGE_REGISTRY_PATH;
        if (this.oauthTokenRegistry == null) {
            this.oauthTokenRegistry = new PersistentTokenRegistry(this.context, (String)finalpath);
        }
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.closeSilently(this.oauthTokenRegistry);
    }
}

