/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingAccountor {
    private static final Logger logger = LoggerFactory.getLogger(SendingAccountor.class);
    private final AtomicInteger batchesSent = new AtomicInteger(0);
    private final Semaphore wait = new Semaphore(0);
    private final AtomicInteger batchesComplete = new AtomicInteger(0);
    private final Semaphore waitComplete = new Semaphore(0);

    void increment() {
        this.batchesSent.incrementAndGet();
    }

    void decrement() {
        this.wait.release();
    }

    void incrementComplete() {
        this.batchesComplete.incrementAndGet();
    }

    void decrementComplete() {
        this.waitComplete.release();
    }

    public synchronized void waitForSendComplete() {
        int waitForBatches = this.batchesSent.get();
        boolean isInterrupted = false;
        while (waitForBatches != 0) {
            try {
                this.wait.acquire(waitForBatches);
                waitForBatches = this.batchesSent.addAndGet(-1 * waitForBatches);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while waiting for send complete. Continuing to wait.", e);
                isInterrupted = true;
            }
        }
        boolean bl = isInterrupted = isInterrupted || this.waitForOperatorComplete();
        if (isInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean waitForOperatorComplete() {
        int waitForBatches = this.batchesComplete.get();
        boolean isInterrupted = false;
        while (waitForBatches != 0) {
            try {
                this.waitComplete.acquire(waitForBatches);
                waitForBatches = this.batchesComplete.addAndGet(-1 * waitForBatches);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while waiting for send complete. Continuing to wait.", e);
                isInterrupted = true;
            }
        }
        return isInterrupted;
    }
}

