/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.Iterator;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.SchemaChangeException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.ops.OperatorStats;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.physical.impl.aggregate.SpilledRecordBatch;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.CloseableRecordBatch;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.record.WritableBatch;
import oadd.org.apache.drill.exec.record.selection.SelectionVector2;
import oadd.org.apache.drill.exec.record.selection.SelectionVector4;
import oadd.org.apache.drill.exec.util.record.RecordBatchStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordBatch<T extends PhysicalOperator>
implements CloseableRecordBatch {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRecordBatch.class);
    protected final VectorContainer container;
    protected final T popConfig;
    protected final FragmentContext context;
    protected final OperatorContext oContext;
    protected final RecordBatchStats.RecordBatchStatsContext batchStatsContext;
    protected final OperatorStats stats;
    protected final boolean unionTypeEnabled;
    protected BatchState state;
    private RecordBatch.IterOutcome lastOutcome;

    protected AbstractRecordBatch(T popConfig, FragmentContext context) throws OutOfMemoryException {
        this(popConfig, context, true, context.newOperatorContext((PhysicalOperator)popConfig));
    }

    protected AbstractRecordBatch(T popConfig, FragmentContext context, boolean buildSchema) throws OutOfMemoryException {
        this(popConfig, context, buildSchema, context.newOperatorContext((PhysicalOperator)popConfig));
    }

    protected AbstractRecordBatch(T popConfig, FragmentContext context, boolean buildSchema, OperatorContext oContext) {
        this.context = context;
        this.popConfig = popConfig;
        this.oContext = oContext;
        this.batchStatsContext = new RecordBatchStats.RecordBatchStatsContext(context, oContext);
        this.stats = oContext.getStats();
        this.container = new VectorContainer(this.oContext.getAllocator());
        this.state = buildSchema ? BatchState.BUILD_SCHEMA : BatchState.FIRST;
        this.unionTypeEnabled = context.getOptions().getBoolean("exec.enable_union_type");
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    @Override
    public FragmentContext getContext() {
        return this.context;
    }

    public T getPopConfig() {
        return this.popConfig;
    }

    public final RecordBatch.IterOutcome next(RecordBatch b) {
        this.checkContinue();
        return this.next(0, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RecordBatch.IterOutcome next(int inputIndex, RecordBatch b) {
        RecordBatch.IterOutcome next;
        try {
            this.stats.stopProcessing();
            this.checkContinue();
            next = b.next();
        }
        finally {
            this.stats.startProcessing();
        }
        if (b instanceof SpilledRecordBatch) {
            return next;
        }
        boolean isNewSchema = false;
        logger.debug("Received next batch for index: {} with outcome: {}", (Object)inputIndex, (Object)next);
        switch (next) {
            case OK_NEW_SCHEMA: {
                isNewSchema = true;
            }
            case OK: 
            case EMIT: {
                this.stats.batchReceived(inputIndex, b.getRecordCount(), isNewSchema);
                logger.debug("Number of records in received batch: {}", (Object)b.getRecordCount());
                break;
            }
        }
        return next;
    }

    @Override
    public final RecordBatch.IterOutcome next() {
        try {
            this.stats.startProcessing();
            block1 : switch (this.state.ordinal()) {
                case 0: {
                    this.buildSchema();
                    switch (this.state.ordinal()) {
                        case 3: {
                            this.lastOutcome = RecordBatch.IterOutcome.NONE;
                            break block1;
                        }
                    }
                    this.state = BatchState.FIRST;
                    this.lastOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                    break;
                }
                case 3: {
                    this.lastOutcome = RecordBatch.IterOutcome.NONE;
                    break;
                }
                default: {
                    this.lastOutcome = this.innerNext();
                }
            }
            RecordBatch.IterOutcome iterOutcome = this.lastOutcome;
            return iterOutcome;
        }
        finally {
            this.stats.stopProcessing();
        }
    }

    public abstract RecordBatch.IterOutcome innerNext();

    @Override
    public BatchSchema getSchema() {
        if (this.container.hasSchema()) {
            return this.container.getSchema();
        }
        return null;
    }

    protected void buildSchema() {
    }

    @Override
    public void cancel() {
        this.cancelIncoming();
    }

    protected abstract void cancelIncoming();

    @Override
    public void close() {
        this.container.clear();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.container.getValueVectorId(path);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.container.getValueAccessorById(clazz, ids);
    }

    @Override
    public WritableBatch getWritableBatch() {
        return WritableBatch.get(this);
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        throw new UnsupportedOperationException(String.format("You should not call getOutgoingContainer() for class %s", this.getClass().getCanonicalName()));
    }

    @Override
    public VectorContainer getContainer() {
        return this.container;
    }

    public RecordBatchStats.RecordBatchStatsContext getRecordBatchStatsContext() {
        return this.batchStatsContext;
    }

    public boolean isRecordBatchStatsLoggingEnabled() {
        return this.batchStatsContext.isEnableBatchSzLogging();
    }

    public void checkContinue() {
        this.context.getExecutorState().checkContinue();
    }

    protected UserException schemaChangeException(SchemaChangeException e, Logger logger) {
        return AbstractRecordBatch.schemaChangeException(e, this.getClass().getSimpleName(), logger);
    }

    public static UserException schemaChangeException(SchemaChangeException e, String operator, Logger logger) {
        return UserException.schemaChangeError(e).addContext("Unexpected schema change in %s operator", operator).build(logger);
    }

    public static enum BatchState {
        BUILD_SCHEMA,
        FIRST,
        NOT_FIRST,
        DONE;

    }
}

