/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.ColumnConverterFactory;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MapColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MetadataUtils;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleSchema;
import oadd.org.apache.drill.exec.vector.accessor.ArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.DictWriter;
import oadd.org.apache.drill.exec.vector.accessor.TupleWriter;

public interface ColumnConverter {
    public void convert(Object var1);

    public static class DictColumnConverter
    implements ColumnConverter {
        private final DictWriter dictWriter;
        private final ColumnConverter keyConverter;
        private final ColumnConverter valueConverter;

        public DictColumnConverter(DictWriter dictWriter, ColumnConverter keyConverter, ColumnConverter valueConverter) {
            this.dictWriter = dictWriter;
            this.keyConverter = keyConverter;
            this.valueConverter = valueConverter;
        }

        @Override
        public void convert(Object value) {
            if (value == null) {
                return;
            }
            Map map = (Map)value;
            map.forEach((key, val) -> {
                this.keyConverter.convert(key);
                this.valueConverter.convert(val);
                this.dictWriter.save();
            });
        }
    }

    public static class MapColumnConverter
    implements ColumnConverter {
        private final ColumnConverterFactory factory;
        private final TupleMetadata providedSchema;
        private final TupleWriter tupleWriter;
        private final Map<String, ColumnConverter> converters;

        public MapColumnConverter(ColumnConverterFactory factory, TupleMetadata providedSchema, TupleWriter tupleWriter, Map<String, ColumnConverter> converters) {
            this.factory = factory;
            this.providedSchema = providedSchema;
            this.tupleWriter = tupleWriter;
            this.converters = new HashMap<String, ColumnConverter>(converters);
        }

        @Override
        public void convert(Object value) {
            if (value == null) {
                return;
            }
            Map record = (Map)value;
            record.forEach(this::processValue);
        }

        private void processValue(String name, Object columnValue) {
            ColumnConverter columnConverter = this.converters.computeIfAbsent(name, columnName -> this.getColumnConverter(columnValue, (String)columnName));
            if (columnConverter != null) {
                columnConverter.convert(columnValue);
            }
        }

        private ColumnConverter getColumnConverter(Object columnValue, String columnName) {
            if (columnValue != null) {
                ColumnMetadata providedColumn = this.providedSchema != null ? this.providedSchema.metadata(columnName) : null;
                ColumnMetadata column = this.buildColumnMetadata(columnName, columnValue);
                if (column != null) {
                    this.tupleWriter.addColumn(providedColumn != null ? providedColumn : column);
                    return this.factory.getConverter(this.providedSchema, column, this.tupleWriter.column(columnName));
                }
            }
            return null;
        }

        private ColumnMetadata buildColumnMetadata(String name, Object value) {
            Class<?> clazz = value.getClass();
            if (Map.class.isAssignableFrom(clazz)) {
                return this.buildMapColumnMetadata(name, (Map)value);
            }
            if (List.class.isAssignableFrom(clazz)) {
                List list = (List)value;
                if (!list.isEmpty()) {
                    Object innerValue = list.iterator().next();
                    return this.buildListColumnMetadata(name, innerValue);
                }
                return null;
            }
            if (clazz.isArray()) {
                Object[] array = (Object[])value;
                if (array.length > 0) {
                    return this.buildListColumnMetadata(name, array[0]);
                }
                return null;
            }
            return MetadataUtils.newScalar(name, this.getScalarMinorType(clazz), TypeProtos.DataMode.OPTIONAL);
        }

        private MapColumnMetadata buildMapColumnMetadata(String name, Map<String, Object> map) {
            TupleSchema schema = new TupleSchema();
            map.forEach((key, value) -> {
                if (value != null) {
                    schema.addColumn(this.buildColumnMetadata((String)key, value));
                }
            });
            return MetadataUtils.newMap(name, (TupleMetadata)schema);
        }

        private ColumnMetadata buildListColumnMetadata(String name, Object innerValue) {
            Class<?> clazz = innerValue.getClass();
            Class<?> componentType = clazz.getComponentType();
            if (List.class.isAssignableFrom(clazz) || componentType != null && componentType.isArray()) {
                return MetadataUtils.newRepeatedList(name, this.buildColumnMetadata(name, innerValue));
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return MetadataUtils.newMapArray(name);
            }
            return MetadataUtils.newScalar(name, this.getScalarMinorType(clazz), TypeProtos.DataMode.REPEATED);
        }

        protected TypeProtos.MinorType getScalarMinorType(Class<?> clazz) {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return TypeProtos.MinorType.TINYINT;
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return TypeProtos.MinorType.SMALLINT;
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return TypeProtos.MinorType.INT;
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return TypeProtos.MinorType.BIGINT;
            }
            if (clazz == Date.class) {
                return TypeProtos.MinorType.DATE;
            }
            if (clazz == Time.class) {
                return TypeProtos.MinorType.TIME;
            }
            if (clazz == Timestamp.class) {
                return TypeProtos.MinorType.TIMESTAMP;
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return TypeProtos.MinorType.FLOAT4;
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return TypeProtos.MinorType.FLOAT8;
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return TypeProtos.MinorType.BIT;
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return TypeProtos.MinorType.VARCHAR;
            }
            if (clazz == String.class) {
                return TypeProtos.MinorType.VARCHAR;
            }
            if (clazz == byte[].class) {
                return TypeProtos.MinorType.VARBINARY;
            }
            if (clazz == BigDecimal.class) {
                return TypeProtos.MinorType.VARDECIMAL;
            }
            throw new IllegalArgumentException("Cannot determine minor type for " + clazz.getName());
        }
    }

    public static class ArrayColumnConverter
    implements ColumnConverter {
        private final ArrayWriter arrayWriter;
        private final ColumnConverter valueConverter;

        public ArrayColumnConverter(ArrayWriter arrayWriter, ColumnConverter valueConverter) {
            this.arrayWriter = arrayWriter;
            this.valueConverter = valueConverter;
        }

        @Override
        public void convert(Object value) {
            List<Object> array;
            if (value == null || !this.arrayWriter.isProjected()) {
                return;
            }
            if (value instanceof Iterable) {
                array = (List<Object>)value;
            } else if (value.getClass().isArray()) {
                array = Arrays.asList((Object[])value);
            } else {
                throw new IllegalStateException("Invalid value type for list ArrayColumnConverter: " + String.valueOf(value.getClass()));
            }
            array.forEach(arrayValue -> {
                this.valueConverter.convert(arrayValue);
                this.arrayWriter.save();
            });
        }
    }

    public static class ScalarColumnConverter
    implements ColumnConverter {
        private final Consumer<Object> valueConverter;

        public ScalarColumnConverter(Consumer<Object> valueConverter) {
            this.valueConverter = valueConverter;
        }

        @Override
        public void convert(Object value) {
            if (value == null) {
                return;
            }
            this.valueConverter.accept(value);
        }
    }

    public static class DummyColumnConverter
    implements ColumnConverter {
        public static final DummyColumnConverter INSTANCE = new DummyColumnConverter();

        @Override
        public void convert(Object value) {
        }
    }
}

