/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.List;
import java.util.Map;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.AllocationHelper;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractMapVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractRepeatedMapVector;

public class VectorInitializer {
    private Map<String, AllocationHint> hints = CaseInsensitiveMap.newHashMap();

    public void variableWidth(String name, int width) {
        this.hints.put(name, new AllocationHint(width, 1.0f));
    }

    public void fixedWidthArray(String name, float elements) {
        this.hints.put(name, new AllocationHint(0, elements));
    }

    public void variableWidthArray(String name, float width, float elements) {
        this.hints.put(name, new AllocationHint((int)Math.ceil(width), elements));
    }

    public AllocationHint hint(String name) {
        return this.hints.get(name);
    }

    public void allocateBatch(VectorAccessible va, int recordCount) {
        for (VectorWrapper w : va) {
            this.allocateVector((ValueVector)w.getValueVector(), "", recordCount);
        }
    }

    public void allocateVectors(List<ValueVector> valueVectors, int recordCount) {
        for (ValueVector v : valueVectors) {
            this.allocateVector(v, v.getField().getName(), recordCount);
        }
    }

    public void allocateVector(ValueVector vector, String prefix, int recordCount) {
        String key = prefix + vector.getField().getName();
        AllocationHint hint = this.hints.get(key);
        if (vector instanceof AbstractMapVector) {
            this.allocateMap((AbstractMapVector)vector, prefix, recordCount, hint);
        } else {
            this.allocateVector(vector, recordCount, hint);
        }
    }

    public void allocateVector(ValueVector vector, int recordCount, AllocationHint hint) {
        if (hint == null) {
            AllocationHelper.allocate(vector, recordCount, 50, 10);
        } else {
            AllocationHelper.allocate(vector, recordCount, hint.entryWidth, hint.elementCount);
        }
    }

    private void allocateMap(AbstractMapVector map, String prefix, int recordCount, AllocationHint hint) {
        if (map instanceof AbstractRepeatedMapVector) {
            ((AbstractRepeatedMapVector)map).allocateOffsetsNew(recordCount);
            recordCount = hint == null ? (recordCount *= 10) : (recordCount *= Math.round(hint.elementCount));
        }
        prefix = (String)prefix + map.getField().getName() + ".";
        for (ValueVector vector : map) {
            this.allocateVector(vector, (String)prefix, recordCount);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[" + this.getClass().getSimpleName()).append(" ");
        boolean first = true;
        for (Map.Entry<String, AllocationHint> entry : this.hints.entrySet()) {
            if (!first) {
                buf.append(", ");
            }
            first = false;
            buf.append("[").append(entry.getKey()).append(" ").append(entry.getValue().toString()).append("]");
        }
        buf.append("]");
        return buf.toString();
    }

    @VisibleForTesting
    public static class AllocationHint {
        public final int entryWidth;
        public final float elementCount;

        private AllocationHint(int width, float elements) {
            this.entryWidth = width;
            this.elementCount = elements;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder().append("{");
            String sep = "";
            if (this.entryWidth > 0) {
                buf.append("width=").append(this.entryWidth);
                sep = ", ";
            }
            if (this.elementCount > 0.0f) {
                buf.append(sep).append("elements=").append(this.elementCount);
            }
            buf.append("}");
            return buf.toString();
        }
    }
}

