/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata.schema;

import java.io.IOException;
import java.util.Map;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.util.DefaultIndenter;
import oadd.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.ObjectReader;
import oadd.com.fasterxml.jackson.databind.ObjectWriter;
import oadd.com.fasterxml.jackson.databind.SerializationFeature;
import oadd.org.apache.drill.common.util.JacksonUtils;
import oadd.org.apache.drill.exec.record.metadata.schema.SchemaContainer;
import oadd.org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import oadd.org.apache.drill.exec.record.metadata.schema.StorageProperties;
import oadd.org.apache.drill.exec.util.ImpersonationUtil;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.fs.FSDataInputStream;
import oadd.org.apache.hadoop.fs.FSDataOutputStream;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.Path;

public class PathSchemaProvider
implements SchemaProvider {
    public static final ObjectReader READER;
    public static final ObjectWriter WRITER;
    private final Path path;
    private final FileSystem fs;

    public PathSchemaProvider(Path path) throws IOException {
        this(PathSchemaProvider.createFsFromPath(path), path);
    }

    public PathSchemaProvider(FileSystem fs, Path path) throws IOException {
        this.fs = ImpersonationUtil.createFileSystem(ImpersonationUtil.getProcessUserName(), fs.getConf());
        if (!fs.exists(path.getParent())) {
            throw new IOException(String.format("Parent path for schema file [%s] does not exist", path.toUri().getPath()));
        }
        this.path = path;
    }

    private static FileSystem createFsFromPath(Path path) throws IOException {
        return path.getFileSystem(new Configuration());
    }

    @Override
    public void delete() throws IOException {
        try {
            if (!this.fs.delete(this.path, false)) {
                throw new IOException(String.format("Error while deleting schema file [%s]", this.path.toUri().getPath()));
            }
        }
        catch (IOException e1) {
            try {
                if (this.exists()) {
                    throw e1;
                }
            }
            catch (IOException e2) {
                throw e1;
            }
        }
    }

    @Override
    public void store(String schema, Map<String, String> properties, StorageProperties storageProperties) throws IOException {
        SchemaContainer tableSchema = this.createTableSchema(schema, properties);
        try (FSDataOutputStream stream = this.fs.create(this.path, storageProperties.isOverwrite());){
            WRITER.writeValue(stream, (Object)tableSchema);
        }
        storageProperties.getStorageStrategy().applyToFile(this.fs, this.path);
    }

    @Override
    public SchemaContainer read() throws IOException {
        try (FSDataInputStream stream = this.fs.open(this.path);){
            SchemaContainer schemaContainer = (SchemaContainer)READER.readValue(stream);
            return schemaContainer;
        }
    }

    @Override
    public boolean exists() throws IOException {
        return this.fs.exists(this.path);
    }

    protected SchemaContainer createTableSchema(String schema, Map<String, String> properties) throws IOException {
        return new SchemaContainer(null, schema, properties);
    }

    static {
        ObjectMapper mapper = JacksonUtils.createObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        READER = mapper.readerFor(SchemaContainer.class);
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter = prettyPrinter.withArrayIndenter(DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        WRITER = mapper.writer(prettyPrinter);
    }
}

