/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import oadd.com.google.common.graph.ImmutableValueGraph;
import oadd.com.google.common.graph.ValueGraphBuilder;
import oadd.org.apache.drill.common.types.TypeProtos;

public class ResolverTypePrecedence {
    public static final ImmutableValueGraph<TypeProtos.MinorType, Float> CAST_GRAPH = ValueGraphBuilder.directed().immutable().putEdgeValue(TypeProtos.MinorType.NULL, TypeProtos.MinorType.VARCHAR, Float.valueOf(1.0f)).putEdgeValue(TypeProtos.MinorType.NULL, TypeProtos.MinorType.BIT, Float.valueOf(1.1f)).putEdgeValue(TypeProtos.MinorType.NULL, TypeProtos.MinorType.INT, Float.valueOf(1.2f)).putEdgeValue(TypeProtos.MinorType.NULL, TypeProtos.MinorType.FLOAT4, Float.valueOf(1.3f)).putEdgeValue(TypeProtos.MinorType.NULL, TypeProtos.MinorType.DECIMAL9, Float.valueOf(1.4f)).putEdgeValue(TypeProtos.MinorType.NULL, TypeProtos.MinorType.DATE, Float.valueOf(1.5f)).putEdgeValue(TypeProtos.MinorType.NULL, TypeProtos.MinorType.INTERVALDAY, Float.valueOf(1.6f)).putEdgeValue(TypeProtos.MinorType.NULL, TypeProtos.MinorType.MONEY, Float.valueOf(1.7f)).putEdgeValue(TypeProtos.MinorType.NULL, TypeProtos.MinorType.LIST, Float.valueOf(1.8f)).putEdgeValue(TypeProtos.MinorType.NULL, TypeProtos.MinorType.DICT, Float.valueOf(1.9f)).putEdgeValue(TypeProtos.MinorType.BIT, TypeProtos.MinorType.TINYINT, Float.valueOf(100.0f)).putEdgeValue(TypeProtos.MinorType.BIT, TypeProtos.MinorType.UINT1, Float.valueOf(100.0f)).putEdgeValue(TypeProtos.MinorType.UINT1, TypeProtos.MinorType.UINT2, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.UINT2, TypeProtos.MinorType.UINT4, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.UINT4, TypeProtos.MinorType.UINT8, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.UINT8, TypeProtos.MinorType.VARDECIMAL, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.UINT4, TypeProtos.MinorType.BIGINT, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.UINT4, TypeProtos.MinorType.FLOAT4, Float.valueOf(11.0f)).putEdgeValue(TypeProtos.MinorType.UINT8, TypeProtos.MinorType.FLOAT4, Float.valueOf(12.0f)).putEdgeValue(TypeProtos.MinorType.TINYINT, TypeProtos.MinorType.SMALLINT, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.SMALLINT, TypeProtos.MinorType.INT, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.INT, TypeProtos.MinorType.BIGINT, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.FLOAT4, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.BIGINT, TypeProtos.MinorType.VARDECIMAL, Float.valueOf(100.0f)).putEdgeValue(TypeProtos.MinorType.FLOAT4, TypeProtos.MinorType.FLOAT8, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.FLOAT8, TypeProtos.MinorType.VARDECIMAL, Float.valueOf(10000.0f)).putEdgeValue(TypeProtos.MinorType.DECIMAL9, TypeProtos.MinorType.DECIMAL18, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.DECIMAL18, TypeProtos.MinorType.DECIMAL28DENSE, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.DECIMAL28DENSE, TypeProtos.MinorType.DECIMAL28SPARSE, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.DECIMAL28SPARSE, TypeProtos.MinorType.DECIMAL38DENSE, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.DECIMAL38DENSE, TypeProtos.MinorType.DECIMAL38SPARSE, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.DECIMAL38SPARSE, TypeProtos.MinorType.VARDECIMAL, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.MONEY, TypeProtos.MinorType.VARDECIMAL, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.VARDECIMAL, TypeProtos.MinorType.FLOAT8, Float.valueOf(1000.0f)).putEdgeValue(TypeProtos.MinorType.VARDECIMAL, TypeProtos.MinorType.FLOAT4, Float.valueOf(1001.0f)).putEdgeValue(TypeProtos.MinorType.VARDECIMAL, TypeProtos.MinorType.INT, Float.valueOf(1002.0f)).putEdgeValue(TypeProtos.MinorType.VARDECIMAL, TypeProtos.MinorType.VARCHAR, Float.valueOf(1003.0f)).putEdgeValue(TypeProtos.MinorType.INTERVALDAY, TypeProtos.MinorType.INTERVALYEAR, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.INTERVALYEAR, TypeProtos.MinorType.INTERVAL, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.INTERVAL, TypeProtos.MinorType.VARCHAR, Float.valueOf(1000.0f)).putEdgeValue(TypeProtos.MinorType.DICT, TypeProtos.MinorType.MAP, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.DATE, TypeProtos.MinorType.TIMESTAMP, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.TIMESTAMP, TypeProtos.MinorType.TIMESTAMPTZ, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.TIME, TypeProtos.MinorType.TIMETZ, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.TIMESTAMP, TypeProtos.MinorType.DATE, Float.valueOf(100.0f)).putEdgeValue(TypeProtos.MinorType.TIMESTAMP, TypeProtos.MinorType.TIME, Float.valueOf(101.0f)).putEdgeValue(TypeProtos.MinorType.TIMESTAMPTZ, TypeProtos.MinorType.VARCHAR, Float.valueOf(1000.0f)).putEdgeValue(TypeProtos.MinorType.TIMETZ, TypeProtos.MinorType.VARCHAR, Float.valueOf(1000.0f)).putEdgeValue(TypeProtos.MinorType.FIXEDCHAR, TypeProtos.MinorType.VARCHAR, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.FIXEDBINARY, TypeProtos.MinorType.VARBINARY, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.BIGINT, Float.valueOf(100.0f)).putEdgeValue(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INT, Float.valueOf(101.0f)).putEdgeValue(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.FLOAT8, Float.valueOf(102.0f)).putEdgeValue(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.FLOAT4, Float.valueOf(103.0f)).putEdgeValue(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARDECIMAL, Float.valueOf(104.0f)).putEdgeValue(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.TIMESTAMP, Float.valueOf(105.0f)).putEdgeValue(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.INTERVALDAY, Float.valueOf(106.0f)).putEdgeValue(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.BIT, Float.valueOf(107.0f)).putEdgeValue(TypeProtos.MinorType.VARCHAR, TypeProtos.MinorType.VARBINARY, Float.valueOf(108.0f)).putEdgeValue(TypeProtos.MinorType.VARBINARY, TypeProtos.MinorType.VARCHAR, Float.valueOf(109.0f)).putEdgeValue(TypeProtos.MinorType.LIST, TypeProtos.MinorType.UNION, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.MAP, TypeProtos.MinorType.UNION, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.VARBINARY, TypeProtos.MinorType.UNION, Float.valueOf(10.0f)).putEdgeValue(TypeProtos.MinorType.UNION, TypeProtos.MinorType.LATE, Float.valueOf(10.0f)).build();

    public static float computeCost(TypeProtos.MinorType fromType, TypeProtos.MinorType toType) {
        TreeSet<VertexDatum> remaining = new TreeSet<VertexDatum>();
        HashMap<TypeProtos.MinorType, VertexDatum> vertexData = new HashMap<TypeProtos.MinorType, VertexDatum>();
        HashSet<TypeProtos.MinorType> shortestPath = new HashSet<TypeProtos.MinorType>();
        VertexDatum sourceDatum = new VertexDatum(fromType, 0.0f, null);
        remaining.add(sourceDatum);
        vertexData.put(fromType, sourceDatum);
        while (!remaining.isEmpty()) {
            VertexDatum vertexDatum = (VertexDatum)remaining.pollFirst();
            TypeProtos.MinorType vertex = vertexDatum.vertex;
            shortestPath.add(vertex);
            if (vertex.equals(toType)) {
                return vertexDatum.totalDistance;
            }
            Set successors = CAST_GRAPH.successors((Object)vertex);
            for (TypeProtos.MinorType successor : successors) {
                if (shortestPath.contains(successor)) continue;
                float distance = ((Float)CAST_GRAPH.edgeValue(vertex, successor).orElseThrow(IllegalStateException::new)).floatValue();
                float totalDistance = vertexDatum.totalDistance + distance;
                VertexDatum successorDatum = (VertexDatum)vertexData.get(successor);
                if (successorDatum == null) {
                    successorDatum = new VertexDatum(successor, totalDistance, vertexDatum);
                    vertexData.put(successor, successorDatum);
                    remaining.add(successorDatum);
                    continue;
                }
                if (!(totalDistance < successorDatum.totalDistance)) continue;
                successorDatum.totalDistance = totalDistance;
                successorDatum.predecessor = vertexDatum;
            }
        }
        return Float.POSITIVE_INFINITY;
    }

    static class VertexDatum
    implements Comparable<VertexDatum> {
        final TypeProtos.MinorType vertex;
        float totalDistance;
        VertexDatum predecessor;

        public VertexDatum(TypeProtos.MinorType vertex, float totalDistance, VertexDatum predecessor) {
            this.vertex = vertex;
            this.totalDistance = totalDistance;
            this.predecessor = predecessor;
        }

        @Override
        public int compareTo(VertexDatum other) {
            int distComparison = Float.compare(this.totalDistance, other.totalDistance);
            return distComparison != 0 ? distComparison : this.vertex.compareTo(other.vertex);
        }

        public String toString() {
            return String.format("vertex: %s, totalDistance: %f, predecessor: %s", this.vertex, Float.valueOf(this.totalDistance), this.predecessor);
        }
    }
}

