/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.Acks;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.UserClientConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDisposableUserClientConnection
implements UserClientConnection {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDisposableUserClientConnection.class);
    protected final CountDownLatch latch = new CountDownLatch(1);
    protected volatile UserBitShared.DrillPBError error;
    protected String queryState;

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void await() throws Exception {
        this.latch.await();
    }

    @Override
    public void sendResult(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, UserBitShared.QueryResult result) {
        Preconditions.checkState(result.hasQueryState());
        UserBitShared.QueryResult.QueryState state = result.getQueryState();
        this.queryState = state.toString();
        UserBitShared.QueryId queryId = result.getQueryId();
        if (logger.isDebugEnabled()) {
            logger.debug("Result arrived for QueryId: {} with QueryState: {}", (Object)QueryIdHelper.getQueryId(queryId), (Object)state);
        }
        switch (state) {
            case FAILED: {
                this.error = result.getError(0);
                this.latch.countDown();
                break;
            }
            case CANCELED: 
            case COMPLETED: {
                Preconditions.checkState(result.getErrorCount() == 0);
                this.latch.countDown();
                break;
            }
            default: {
                logger.error("Query with QueryId: {} is in unexpected state: {}", (Object)queryId, (Object)state);
            }
        }
        listener.success(Acks.OK, null);
    }

    public UserBitShared.DrillPBError getError() {
        return this.error;
    }

    public String getQueryState() {
        return this.queryState;
    }
}

