/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.rpc.AbstractRemoteConnection;
import oadd.org.apache.drill.exec.rpc.ConnectionConfig;
import oadd.org.apache.drill.exec.rpc.RequestHandler;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.SaslCodec;
import oadd.org.apache.drill.exec.rpc.ServerConnection;
import oadd.org.apache.drill.exec.rpc.security.SaslProperties;
import oadd.org.apache.hadoop.security.HadoopKerberosName;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;

public abstract class AbstractServerConnection<S extends ServerConnection<S>>
extends AbstractRemoteConnection
implements ServerConnection<S> {
    private final ConnectionConfig config;
    private RequestHandler<S> currentHandler;
    private SaslServer saslServer;

    public AbstractServerConnection(SocketChannel channel, String name, ConnectionConfig config, RequestHandler<S> handler) {
        super(channel, name, config.getEncryptionCtxt());
        this.config = config;
        this.currentHandler = handler;
    }

    public AbstractServerConnection(SocketChannel channel, ConnectionConfig config, RequestHandler<S> handler) {
        this(channel, config.getName(), config, handler);
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.config.getAllocator();
    }

    protected abstract Logger getLogger();

    @Override
    public void initSaslServer(String mechanismName) throws SaslException {
        Preconditions.checkState(this.saslServer == null);
        try {
            this.saslServer = this.config.getAuthProvider().getAuthenticatorFactory(mechanismName).createSaslServer(UserGroupInformation.getLoginUser(), SaslProperties.getSaslProperties(this.isEncryptionEnabled(), this.getMaxWrappedSize()));
        }
        catch (IOException e) {
            this.getLogger().debug("Login failed.", e);
            Throwable cause = e.getCause();
            if (cause instanceof LoginException) {
                throw new SaslException("Failed to login.", cause);
            }
            throw new SaslException("Unexpected failure trying to login.", cause);
        }
        if (this.saslServer == null) {
            throw new SaslException(String.format("Server cannot initiate authentication using %s mechanism. Insufficient parameters or selected mechanism doesn't support configured security layers ?", mechanismName));
        }
        if (this.isEncryptionEnabled()) {
            this.saslCodec = new SaslCodec(){

                @Override
                public byte[] wrap(byte[] data, int offset, int len) throws SaslException {
                    Preconditions.checkState(AbstractServerConnection.this.saslServer != null);
                    return AbstractServerConnection.this.saslServer.wrap(data, offset, len);
                }

                @Override
                public byte[] unwrap(byte[] data, int offset, int len) throws SaslException {
                    Preconditions.checkState(AbstractServerConnection.this.saslServer != null);
                    return AbstractServerConnection.this.saslServer.unwrap(data, offset, len);
                }
            };
        }
    }

    @Override
    public SaslServer getSaslServer() {
        Preconditions.checkState(this.saslServer != null);
        return this.saslServer;
    }

    @Override
    public void finalizeSaslSession() throws IOException {
        String authorizationID = this.getSaslServer().getAuthorizationID();
        String remoteShortName = new HadoopKerberosName(authorizationID).getShortName();
        String localShortName = UserGroupInformation.getLoginUser().getShortUserName();
        if (!localShortName.equals(remoteShortName)) {
            throw new SaslException(String.format("'primary' part of remote drillbit's service principal does not match with this drillbit's. Expected: '%s' Actual: '%s'", localShortName, remoteShortName));
        }
        this.getLogger().debug("Authenticated connection for {}", (Object)authorizationID);
    }

    @Override
    public RequestHandler<S> getCurrentHandler() {
        return this.currentHandler;
    }

    @Override
    public void changeHandlerTo(RequestHandler<S> handler) {
        Preconditions.checkNotNull(handler);
        this.currentHandler = handler;
    }

    @Override
    public void setEncryption(boolean encrypted) {
        throw new UnsupportedOperationException("Changing encryption setting on server connection is not permitted.");
    }

    @Override
    public void setMaxWrappedSize(int maxWrappedSize) {
        throw new UnsupportedOperationException("Changing maxWrappedSize setting on server connection is not permitted.");
    }

    @Override
    public void disposeSaslServer() {
        try {
            if (this.saslServer != null) {
                this.saslServer.dispose();
                this.saslServer = null;
            }
        }
        catch (SaslException e) {
            this.getLogger().warn("Unclean disposal.", e);
        }
    }

    @Override
    public void channelClosed(RpcException ex) {
        this.disposeSaslServer();
        this.decConnectionCounter();
        super.channelClosed(ex);
    }
}

