/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.util.ArrayList;
import java.util.Arrays;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.MessageLite;
import oadd.io.netty.buffer.ByteBuf;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.rpc.RpcEncoder;
import oadd.org.apache.drill.exec.rpc.RpcMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundRpcMessage
extends RpcMessage {
    static final Logger logger = LoggerFactory.getLogger(OutboundRpcMessage.class);
    final MessageLite pBody;
    public ByteBuf[] dBodies;

    public OutboundRpcMessage(GeneralRPCProtos.RpcMode mode, Internal.EnumLite rpcType, int coordinationId, MessageLite pBody, ByteBuf ... dBodies) {
        this(mode, rpcType.getNumber(), coordinationId, pBody, dBodies);
    }

    OutboundRpcMessage(GeneralRPCProtos.RpcMode mode, int rpcTypeNumber, int coordinationId, MessageLite pBody, ByteBuf ... dBodies) {
        super(mode, rpcTypeNumber, coordinationId);
        this.pBody = pBody;
        ArrayList<ByteBuf> bufs = Lists.newArrayList();
        for (ByteBuf d : dBodies) {
            if (d.readableBytes() == 0) {
                d.release();
                continue;
            }
            bufs.add(d);
        }
        this.dBodies = bufs.toArray(new ByteBuf[bufs.size()]);
    }

    @Override
    public int getBodySize() {
        int len = this.pBody.getSerializedSize();
        len += RpcEncoder.getRawVarintSize(len);
        return len += this.getRawBodySize();
    }

    public int getRawBodySize() {
        if (this.dBodies == null) {
            return 0;
        }
        int len = 0;
        for (int i = 0; i < this.dBodies.length; ++i) {
            len += this.dBodies[i].readableBytes();
        }
        return len;
    }

    public String toString() {
        return "OutboundRpcMessage [pBody=" + String.valueOf(this.pBody) + ", mode=" + String.valueOf(this.mode) + ", rpcType=" + this.rpcType + ", coordinationId=" + this.coordinationId + ", dBodies=" + Arrays.toString(this.dBodies) + "]";
    }

    @Override
    void release() {
        if (this.dBodies != null) {
            for (ByteBuf b : this.dBodies) {
                b.release();
            }
        }
    }
}

