/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.base.Strings;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.calcite.schema.Schema;
import oadd.org.apache.calcite.schema.SchemaPlus;
import oadd.org.apache.calcite.schema.Table;
import oadd.org.apache.calcite.tools.ValidationException;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.config.DrillProperties;
import oadd.org.apache.drill.exec.planner.sql.SchemaUtilities;
import oadd.org.apache.drill.exec.planner.sql.handlers.SqlHandlerUtil;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.user.InboundImpersonationManager;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.SessionOptionManager;
import oadd.org.apache.drill.exec.store.AbstractSchema;
import oadd.org.apache.drill.exec.store.StorageStrategy;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import oadd.org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSession
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(UserSession.class);
    private boolean supportComplexTypes;
    private UserBitShared.UserCredentials credentials;
    private DrillProperties properties;
    private SessionOptionManager sessionOptions;
    private final AtomicInteger queryCount = new AtomicInteger(0);
    private final String sessionId = UUID.randomUUID().toString();
    private final ConcurrentMap<String, String> temporaryTables = Maps.newConcurrentMap();
    private final ConcurrentMap<Path, FileSystem> temporaryLocations = Maps.newConcurrentMap();

    @Override
    public void close() {
        for (Map.Entry entry : this.temporaryLocations.entrySet()) {
            Path path = (Path)entry.getKey();
            FileSystem fs = (FileSystem)entry.getValue();
            try {
                fs.delete(path, true);
                logger.info("Deleted session temporary location [{}] from file system [{}]", (Object)path.toUri().getPath(), (Object)fs.getUri());
            }
            catch (Exception e) {
                logger.warn("Error during session temporary location [{}] deletion from file system [{}]: [{}]", path.toUri().getPath(), fs.getUri(), e.getMessage());
            }
        }
        this.temporaryLocations.clear();
    }

    private UserSession() {
        this.properties = DrillProperties.createEmpty();
    }

    public boolean isSupportComplexTypes() {
        return this.supportComplexTypes;
    }

    public SessionOptionManager getOptions() {
        return this.sessionOptions;
    }

    public UserBitShared.UserCredentials getCredentials() {
        return this.credentials;
    }

    public void replaceUserCredentials(InboundImpersonationManager impersonationManager, UserBitShared.UserCredentials newCredentials) {
        Preconditions.checkNotNull(impersonationManager, "User credentials can only be replaced by an impersonation manager.");
        this.credentials = newCredentials;
    }

    public String getTargetUserName() {
        return this.properties.getProperty("impersonation_target");
    }

    public void incrementQueryCount(QueryCountIncrementer incrementer) {
        assert (incrementer != null);
        this.queryCount.incrementAndGet();
    }

    public int getQueryCount() {
        return this.queryCount.get();
    }

    public void setDefaultSchemaPath(String newDefaultSchemaPath, SchemaPlus currentDefaultSchema) throws ValidationException {
        List newDefaultPathAsList = SchemaUtilities.getSchemaPathAsList((String)newDefaultSchemaPath);
        SchemaPlus newDefault = SchemaUtilities.findSchema((SchemaPlus)currentDefaultSchema, (List)newDefaultPathAsList);
        if (newDefault == null) {
            newDefault = SchemaUtilities.findSchema((SchemaPlus)currentDefaultSchema, (List)newDefaultPathAsList);
        }
        if (newDefault == null) {
            SchemaUtilities.throwSchemaNotFoundException((SchemaPlus)currentDefaultSchema, (String)newDefaultSchemaPath);
        }
        this.properties.setProperty("schema", SchemaUtilities.getSchemaPath((SchemaPlus)newDefault));
    }

    public String getDefaultSchemaPath() {
        return this.properties.getProperty("schema", "");
    }

    public SchemaPlus getDefaultSchema(SchemaPlus rootSchema) {
        String defaultSchemaPath = this.getDefaultSchemaPath();
        if (Strings.isNullOrEmpty(defaultSchemaPath)) {
            return null;
        }
        return SchemaUtilities.findSchema((SchemaPlus)rootSchema, (String)defaultSchemaPath);
    }

    public void setSessionOption(String name, String value) {
        this.sessionOptions.setLocalOption(name, value);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String registerTemporaryTable(AbstractSchema schema, String tableName, DrillConfig config) throws IOException {
        this.addTemporaryLocation(SchemaUtilities.resolveToValidTemporaryWorkspace((AbstractSchema)schema, (DrillConfig)config));
        String temporaryTableName = new Path(this.sessionId, UUID.randomUUID().toString()).toUri().getPath();
        String oldTemporaryTableName = this.temporaryTables.putIfAbsent(tableName.toLowerCase(), temporaryTableName);
        return oldTemporaryTableName == null ? temporaryTableName : oldTemporaryTableName;
    }

    public String resolveTemporaryTableName(String tableName) {
        return (String)this.temporaryTables.get(tableName.toLowerCase());
    }

    public String getOriginalTableNameFromTemporaryTable(String tableName) {
        for (String originalTableName : this.temporaryTables.keySet()) {
            if (!((String)this.temporaryTables.get(originalTableName)).equals(tableName)) continue;
            return originalTableName;
        }
        return null;
    }

    public boolean isTemporaryTable(AbstractSchema drillSchema, DrillConfig config, String tableName) {
        Table temporaryTable;
        if (drillSchema == null || !SchemaUtilities.isTemporaryWorkspace((String)drillSchema.getFullSchemaName(), (DrillConfig)config)) {
            return false;
        }
        String temporaryTableName = this.resolveTemporaryTableName(tableName);
        return temporaryTableName != null && (temporaryTable = SqlHandlerUtil.getTableFromSchema((AbstractSchema)drillSchema, (String)temporaryTableName)) != null && temporaryTable.getJdbcTableType() == Schema.TableType.TABLE;
    }

    public void removeTemporaryTable(AbstractSchema schema, String tableName, DrillConfig config) {
        String temporaryTable = this.resolveTemporaryTableName(tableName);
        if (temporaryTable == null) {
            return;
        }
        SqlHandlerUtil.dropTableFromSchema((AbstractSchema)SchemaUtilities.resolveToValidTemporaryWorkspace((AbstractSchema)schema, (DrillConfig)config), (String)temporaryTable);
        this.temporaryTables.remove(tableName.toLowerCase());
    }

    private void addTemporaryLocation(WorkspaceSchemaFactory.WorkspaceSchema temporaryWorkspace) throws IOException {
        DrillFileSystem fs = temporaryWorkspace.getFS();
        Path temporaryLocation = new Path(fs.getUri().toString(), new Path(temporaryWorkspace.getDefaultLocation(), this.sessionId));
        FileSystem fileSystem = this.temporaryLocations.putIfAbsent(temporaryLocation, (FileSystem)fs);
        if (fileSystem == null) {
            StorageStrategy.TEMPORARY.createPathAndApply((FileSystem)fs, temporaryLocation);
            Preconditions.checkArgument(fs.exists(temporaryLocation), String.format("Temporary location should exist [%s]", temporaryLocation.toUri().getPath()));
        }
    }

    public static class Builder {
        private UserSession userSession = new UserSession();

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withCredentials(UserBitShared.UserCredentials credentials) {
            this.userSession.credentials = credentials;
            return this;
        }

        public Builder withOptionManager(OptionManager systemOptions) {
            this.userSession.sessionOptions = new SessionOptionManager(systemOptions, this.userSession);
            return this;
        }

        public Builder withUserProperties(UserProtos.UserProperties properties) {
            this.userSession.properties = DrillProperties.createFromProperties(properties, false);
            return this;
        }

        public Builder setSupportComplexTypes(boolean supportComplexTypes) {
            this.userSession.supportComplexTypes = supportComplexTypes;
            return this;
        }

        private boolean canApplyUserProperty() {
            StringBuilder sb = new StringBuilder();
            if (this.userSession.properties.containsKey("quoting_identifiers")) {
                sb.append("quoting_identifiers").append(",");
            }
            if (this.userSession.properties.containsKey("queryTags")) {
                sb.append("queryTags");
            }
            if (this.userSession.sessionOptions == null && sb.length() > 0) {
                logger.warn("User property {} can't be installed as a server option without the session option manager", (Object)sb.toString());
                return false;
            }
            return true;
        }

        public UserSession build() {
            if (this.canApplyUserProperty()) {
                if (this.userSession.properties.containsKey("quoting_identifiers")) {
                    this.userSession.setSessionOption("planner.parser.quoting_identifiers", this.userSession.properties.getProperty("quoting_identifiers"));
                }
                if (this.userSession.properties.containsKey("queryTags")) {
                    this.userSession.setSessionOption("exec.rm.queryTags", this.userSession.properties.getProperty("queryTags"));
                }
            }
            UserSession session = this.userSession;
            this.userSession = null;
            return session;
        }

        Builder() {
        }
    }

    public static interface QueryCountIncrementer {
        public void increment(UserSession var1);
    }
}

