/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.util.Iterator;
import java.util.Map;
import oadd.com.typesafe.config.ConfigValue;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillConfigIterator
implements Iterable<OptionValue> {
    static final Logger logger = LoggerFactory.getLogger(DrillConfigIterator.class);
    DrillConfig c;

    public DrillConfigIterator(DrillConfig c) {
        this.c = c;
    }

    @Override
    public Iterator<OptionValue> iterator() {
        return new Iter(this.c);
    }

    public class Iter
    implements Iterator<OptionValue> {
        Iterator<Map.Entry<String, ConfigValue>> entries;

        public Iter(DrillConfig c) {
            this.entries = c.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public OptionValue next() {
            Map.Entry<String, ConfigValue> e = this.entries.next();
            ConfigValue cv = e.getValue();
            String name = e.getKey();
            OptionValue optionValue = null;
            switch (cv.valueType()) {
                case BOOLEAN: {
                    optionValue = OptionValue.create(OptionValue.AccessibleScopes.BOOT, name, (Boolean)cv.unwrapped(), OptionValue.OptionScope.BOOT);
                    break;
                }
                case LIST: 
                case OBJECT: 
                case STRING: {
                    optionValue = OptionValue.create(OptionValue.AccessibleScopes.BOOT, name, cv.render(), OptionValue.OptionScope.BOOT);
                    break;
                }
                case NUMBER: {
                    optionValue = OptionValue.create(OptionValue.AccessibleScopes.BOOT, name, ((Number)cv.unwrapped()).longValue(), OptionValue.OptionScope.BOOT);
                    break;
                }
                case NULL: {
                    throw new IllegalStateException("Config value \"" + name + "\" has NULL type");
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + String.valueOf((Object)cv.valueType()));
                }
            }
            return optionValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

