/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server.options;

import java.util.HashMap;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;
import oadd.org.apache.drill.exec.server.options.InMemoryOptionManager;
import oadd.org.apache.drill.exec.server.options.OptionList;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.server.options.SessionOptionManager;

public class QueryOptionManager
extends InMemoryOptionManager {
    public QueryOptionManager(OptionManager sessionOptions) {
        super(sessionOptions, CaseInsensitiveMap.newHashMap());
    }

    @Override
    public OptionList getOptionList() {
        HashMap<String, OptionValue> optionMap = new HashMap<String, OptionValue>();
        for (OptionValue option : this.fallback.getOptionList()) {
            optionMap.put(option.name, option);
        }
        for (OptionValue option : super.getOptionList()) {
            optionMap.put(option.name, option);
        }
        return new OptionList(optionMap.values());
    }

    @Override
    public OptionValue getDefault(String optionName) {
        return this.fallback.getDefault(optionName);
    }

    public SessionOptionManager getSessionOptionManager() {
        return (SessionOptionManager)this.fallback;
    }

    public OptionManager getOptionManager(OptionValue.OptionScope scope) {
        switch (scope) {
            case SYSTEM: {
                return this.getSessionOptionManager().getSystemOptionManager();
            }
            case SESSION: {
                return this.getSessionOptionManager();
            }
            case QUERY: {
                return this;
            }
            case BOOT: {
                throw new UnsupportedOperationException("There is no option manager for " + String.valueOf((Object)OptionValue.OptionScope.BOOT));
            }
        }
        throw new UnsupportedOperationException("Invalid type: " + String.valueOf((Object)scope));
    }

    @Override
    protected OptionValue.OptionScope getScope() {
        return OptionValue.OptionScope.QUERY;
    }
}

