/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.testing;

import java.io.IOException;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.KeyDeserializer;
import oadd.com.google.common.base.Preconditions;

public class InjectionSite {
    private final Class<?> clazz;
    private final String desc;
    private static final String SEPARATOR = ",";

    public InjectionSite(Class<?> clazz, String desc) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(desc);
        this.clazz = clazz;
        this.desc = desc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof InjectionSite)) {
            return false;
        }
        InjectionSite other = (InjectionSite)o;
        if (this.clazz != other.clazz) {
            return false;
        }
        return this.desc.equals(other.desc);
    }

    public String toString() {
        return this.clazz.getName() + SEPARATOR + this.desc;
    }

    public int hashCode() {
        return this.clazz.hashCode() + 13 ^ 1 - this.desc.hashCode();
    }

    public static class InjectionSiteKeyDeserializer
    extends KeyDeserializer {
        @Override
        public Object deserializeKey(String key, DeserializationContext context) throws IOException, JsonProcessingException {
            Class<?> siteClass;
            String[] fields = key.split(InjectionSite.SEPARATOR);
            try {
                siteClass = Class.forName(fields[0]);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Class " + fields[0] + " not found.", e);
            }
            return new InjectionSite(siteClass, fields[1]);
        }
    }
}

