/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import oadd.com.google.common.math.BigIntegerMath;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.DrillBuf;
import oadd.io.netty.buffer.UnpooledByteBufAllocator;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.types.TypeProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecimalUtility {
    public static final int MAX_DIGITS = 9;
    public static final int MAX_DIGITS_INT = 10;
    public static final int MAX_DIGITS_BIGINT = 19;
    public static final int DIGITS_BASE = 1000000000;
    public static final int INTEGER_SIZE = 4;
    private static final Logger logger = LoggerFactory.getLogger(DecimalUtility.class);

    public static int roundUp(int ndigits) {
        return (ndigits + 9 - 1) / 9;
    }

    public static BigDecimal getBigDecimalFromSparse(DrillBuf data, int startIndex, int nDecimalDigits, int scale) {
        return DecimalUtility.getBigDecimalFromDrillBuf(data, startIndex, nDecimalDigits, scale, true);
    }

    public static BigDecimal getBigDecimalFromDrillBuf(DrillBuf bytebuf, int start, int length, int scale) {
        byte[] value = new byte[length];
        bytebuf.getBytes(start, value, 0, length);
        BigInteger unscaledValue = length == 0 ? BigInteger.ZERO : new BigInteger(value);
        return new BigDecimal(unscaledValue, scale);
    }

    public static BigDecimal getBigDecimalFromDrillBuf(ByteBuf data, int startIndex, int nDecimalDigits, int scale, boolean truncateScale) {
        int actualDigits = scale % 9;
        BigInteger decimalDigits = BigInteger.valueOf(data.getInt(startIndex) & Integer.MAX_VALUE);
        BigInteger base = BigInteger.valueOf(1000000000L);
        for (int i = 1; i < nDecimalDigits; ++i) {
            BigInteger temp = BigInteger.valueOf(data.getInt(startIndex + i * 4));
            decimalDigits = decimalDigits.multiply(base);
            decimalDigits = decimalDigits.add(temp);
        }
        if (truncateScale && scale > 0 && actualDigits != 0) {
            BigInteger truncate = BigInteger.valueOf((int)Math.pow(10.0, 9 - actualDigits));
            decimalDigits = decimalDigits.divide(truncate);
        }
        if ((data.getInt(startIndex) & Integer.MIN_VALUE) != 0) {
            decimalDigits = decimalDigits.negate();
        }
        return new BigDecimal(decimalDigits, scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getBigDecimalFromDense(DrillBuf data, int startIndex, int nDecimalDigits, int scale, int maxPrecision, int width) {
        byte shiftBits;
        int shiftOrder;
        int maskIndex;
        byte[] intermediateBytes = new byte[(nDecimalDigits + 1) * 4];
        int intermediateIndex = 3;
        int[] mask = new int[]{3, 15, 63, 255};
        int[] reverseMask = new int[]{252, 240, 192, 0};
        if (maxPrecision == 38) {
            maskIndex = 0;
            shiftOrder = 6;
            shiftBits = 0;
            intermediateBytes[intermediateIndex++] = (byte)(data.getByte(startIndex) & 0x7F);
        } else if (maxPrecision == 28) {
            maskIndex = 1;
            shiftOrder = 4;
            shiftBits = (byte)((data.getByte(startIndex) & 3) << shiftOrder);
            intermediateBytes[intermediateIndex++] = (byte)((data.getByte(startIndex) & 0x3C & 0xFF) >>> 2);
        } else {
            throw new UnsupportedOperationException("Dense types with max precision 38 and 28 are only supported");
        }
        int inputIndex = 1;
        boolean sign = false;
        if ((data.getByte(startIndex) & 0x80) != 0) {
            sign = true;
        }
        while (inputIndex < width) {
            intermediateBytes[intermediateIndex] = (byte)(shiftBits | (data.getByte(startIndex + inputIndex) & reverseMask[maskIndex] & 0xFF) >>> 8 - shiftOrder);
            shiftBits = (byte)((data.getByte(startIndex + inputIndex) & mask[maskIndex]) << shiftOrder);
            ++intermediateIndex;
            if ((++inputIndex - 1) % 4 != 0) continue;
            shiftBits = (byte)((shiftBits & 0xFF) >>> 2);
            ++maskIndex;
            shiftOrder -= 2;
        }
        intermediateBytes[intermediateIndex] = shiftBits;
        if (sign) {
            intermediateBytes[0] = (byte)(intermediateBytes[0] | 0x80);
        }
        ByteBuf intermediate = UnpooledByteBufAllocator.DEFAULT.buffer(intermediateBytes.length);
        try {
            intermediate.setBytes(0, intermediateBytes);
            BigDecimal bigDecimal = DecimalUtility.getBigDecimalFromDrillBuf(intermediate, 0, nDecimalDigits + 1, scale, false);
            return bigDecimal;
        }
        finally {
            intermediate.release();
        }
    }

    public static void getSparseFromBigDecimal(BigDecimal input, ByteBuf data, int startIndex, int scale, int nDecimalDigits) {
        data.setZero(startIndex, nDecimalDigits * 4);
        boolean sign = false;
        if (input.signum() == -1) {
            sign = true;
            input = input.abs();
        }
        input = input.setScale(scale, 4);
        BigDecimal integerPart = input.setScale(0, 1);
        int destIndex = nDecimalDigits - DecimalUtility.roundUp(scale) - 1;
        BigDecimal base = new BigDecimal(1000000000);
        while (integerPart.compareTo(BigDecimal.ZERO) == 1) {
            data.setInt(startIndex + destIndex * 4, integerPart.remainder(base).intValue());
            --destIndex;
            integerPart = integerPart.divide(base, 1).setScale(0, 1);
        }
        int actualDigits = scale % 9;
        if (actualDigits != 0) {
            scale = scale + 9 - actualDigits;
            input = input.setScale(scale, 1);
        }
        BigDecimal fractionalPart = input.remainder(BigDecimal.ONE).movePointRight(scale);
        destIndex = nDecimalDigits - 1;
        while (scale > 0) {
            fractionalPart = fractionalPart.movePointLeft(9);
            BigDecimal temp = fractionalPart.remainder(BigDecimal.ONE);
            data.setInt(startIndex + destIndex * 4, temp.unscaledValue().intValue());
            --destIndex;
            fractionalPart = fractionalPart.setScale(0, 1);
            scale -= 9;
        }
        if (sign) {
            data.setInt(startIndex, data.getInt(startIndex) | Integer.MIN_VALUE);
        }
    }

    public static long getDecimal18FromBigDecimal(BigDecimal input, int scale) {
        input = input.setScale(scale, 4);
        return input.unscaledValue().longValue();
    }

    public static int getDecimal9FromBigDecimal(BigDecimal input, int scale) {
        input = input.setScale(scale, 4);
        return input.unscaledValue().intValue();
    }

    public static BigDecimal getBigDecimalFromPrimitiveTypes(int input, int scale) {
        return BigDecimal.valueOf(input, scale);
    }

    public static BigDecimal getBigDecimalFromPrimitiveTypes(long input, int scale) {
        return BigDecimal.valueOf(input, scale);
    }

    public static int compareVarLenBytes(DrillBuf left, int leftStart, int leftEnd, int leftScale, DrillBuf right, int rightStart, int rightEnd, int rightScale, boolean absCompare) {
        byte[] rightBytes = new byte[rightEnd - rightStart];
        right.getBytes(rightStart, rightBytes, 0, rightEnd - rightStart);
        return DecimalUtility.compareVarLenBytes(left, leftStart, leftEnd, leftScale, rightBytes, rightScale, absCompare);
    }

    public static int compareVarLenBytes(DrillBuf left, int leftStart, int leftEnd, int leftScale, byte[] right, int rightScale, boolean absCompare) {
        BigDecimal bdLeft = DecimalUtility.getBigDecimalFromDrillBuf(left, leftStart, leftEnd - leftStart, leftScale);
        BigDecimal bdRight = new BigDecimal(right.length == 0 ? BigInteger.ZERO : new BigInteger(right), rightScale);
        if (absCompare) {
            bdLeft = bdLeft.abs();
            bdRight = bdRight.abs();
        }
        return bdLeft.compareTo(bdRight);
    }

    public static int getMaxBytesSizeForPrecision(int precision) {
        if (precision == 0) {
            return 0;
        }
        if (precision < 300) {
            return (int)Math.ceil((Math.log(Math.pow(10.0, precision) - 1.0) / Math.log(2.0) + 1.0) / 8.0);
        }
        return (int)Math.ceil(((double)precision * Math.log(10.0) / Math.log(2.0) + 1.0) / 8.0);
    }

    public static BigDecimal sqrt(BigDecimal in, int scale) {
        BigInteger valueWithDoubleMaxPrecision = in.multiply(BigDecimal.TEN.pow(scale * 2)).setScale(0, RoundingMode.HALF_UP).unscaledValue();
        return new BigDecimal(BigIntegerMath.sqrt(valueWithDoubleMaxPrecision, RoundingMode.HALF_UP), scale);
    }

    public static boolean isObsoleteDecimalType(TypeProtos.MinorType minorType) {
        return minorType == TypeProtos.MinorType.DECIMAL9 || minorType == TypeProtos.MinorType.DECIMAL18 || minorType == TypeProtos.MinorType.DECIMAL28SPARSE || minorType == TypeProtos.MinorType.DECIMAL38SPARSE;
    }

    public static int getDefaultPrecision(TypeProtos.MinorType minorType, int defaultPrecision) {
        switch (minorType) {
            case INT: {
                return 10;
            }
            case BIGINT: {
                return 19;
            }
        }
        return defaultPrecision;
    }

    public static void checkValueOverflow(BigDecimal value, int desiredPrecision, int desiredScale) {
        if (value.precision() - value.scale() > desiredPrecision - desiredScale) {
            throw UserException.validationError().message("Value %s overflows specified precision %s with scale %s.", value, desiredPrecision, desiredScale).build(logger);
        }
    }
}

