/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.IntervalDayHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.DateUtilities;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.NullableIntervalDayVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.impl.IntervalDayReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntervalDayVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(IntervalDayVector.class);
    public static final int VALUE_WIDTH = 12;
    public static final int MAX_VALUE_COUNT = MAX_BUFFER_SIZE / 12;
    public static final int MAX_SCALAR_COUNT = Math.min(65536, MAX_VALUE_COUNT);
    public static final int NET_MAX_SCALAR_SIZE = 12 * MAX_SCALAR_COUNT;
    private final FieldReader reader = new IntervalDayReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = Math.min(49152, MAX_BUFFER_SIZE);
    private int allocationMonitor = 0;

    public IntervalDayVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 12;
    }

    @Override
    public int getValueCapacity() {
        return this.data.capacity() / 12;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = (long)valueCount * 12L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 12);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize;
        int currentCapacity = this.data.capacity();
        for (newAllocationSize = this.allocationSizeInBytes == 0 ? 256L : (long)this.allocationSizeInBytes * 2L; newAllocationSize < (long)currentCapacity; newAllocationSize *= 2L) {
        }
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        this.reallocRaw((int)newAllocationSize);
        this.data.setZero(currentCapacity, this.data.capacity() - currentCapacity);
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        if (newAllocationSize == 0) {
            throw new IllegalStateException("Attempt to reAlloc a zero-sized vector");
        }
        DrillBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = newAllocationSize;
        return newBuf;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", (Object)this.field, (Object)metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 12;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntervalDayVector)to);
    }

    public void transferTo(IntervalDayVector target) {
        target.clear();
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, IntervalDayVector target) {
        int startPoint = startIndex * 12;
        int sliceLength = length * 12;
        target.clear();
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(sliceLength);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return valueCount * 12;
    }

    @Override
    public int getValueWidth() {
        return 12;
    }

    public void copyFrom(int fromIndex, int thisIndex, IntervalDayVector from) {
        from.data.getBytes(fromIndex * 12, this.data, thisIndex * 12, 12);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, IntervalDayVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (IntervalDayVector)from);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        NullableIntervalDayVector dest = (NullableIntervalDayVector)nullableVector;
        dest.getMutator().fromNotNullable(this);
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return IntervalDayVector.this.data.writerIndex() / 12;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public DrillBuf get(int index) {
            return IntervalDayVector.this.data.slice(index * 12, 12);
        }

        public void get(int index, IntervalDayHolder holder) {
            int offsetIndex = index * 12;
            holder.days = IntervalDayVector.this.data.getInt(offsetIndex);
            holder.milliseconds = IntervalDayVector.this.data.getInt(offsetIndex + 4);
        }

        public void get(int index, NullableIntervalDayHolder holder) {
            int offsetIndex = index * 12;
            holder.isSet = 1;
            holder.days = IntervalDayVector.this.data.getInt(offsetIndex);
            holder.milliseconds = IntervalDayVector.this.data.getInt(offsetIndex + 4);
        }

        @Override
        public Period getObject(int index) {
            int offsetIndex = index * 12;
            int days = IntervalDayVector.this.data.getInt(offsetIndex);
            int millis = IntervalDayVector.this.data.getInt(offsetIndex + 4);
            return DateUtilities.fromIntervalDay(days, millis);
        }

        public StringBuilder getAsStringBuilder(int index) {
            int offsetIndex = index * 12;
            int days = IntervalDayVector.this.data.getInt(offsetIndex);
            int millis = IntervalDayVector.this.data.getInt(offsetIndex + 4);
            return DateUtilities.intervalDayStringBuilder(days, millis);
        }
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, DrillBuf value) {
            IntervalDayVector.this.data.setBytes(index * 12, value, 0, 12);
        }

        public void setSafe(int index, DrillBuf value) {
            while (index >= IntervalDayVector.this.getValueCapacity()) {
                IntervalDayVector.this.reAlloc();
            }
            IntervalDayVector.this.data.setBytes(index * 12, value, 0, 12);
        }

        public void set(int index, int days, int milliseconds) {
            int offsetIndex = index * 12;
            IntervalDayVector.this.data.setInt(offsetIndex, days);
            IntervalDayVector.this.data.setInt(offsetIndex + 4, milliseconds);
        }

        public void setSafe(int index, int days, int milliseconds) {
            while (index >= IntervalDayVector.this.getValueCapacity()) {
                IntervalDayVector.this.reAlloc();
            }
            this.set(index, days, milliseconds);
        }

        protected void set(int index, IntervalDayHolder holder) {
            this.set(index, holder.days, holder.milliseconds);
        }

        public void setSafe(int index, IntervalDayHolder holder) {
            this.setSafe(index, holder.days, holder.milliseconds);
        }

        protected void set(int index, NullableIntervalDayHolder holder) {
            this.set(index, holder.days, holder.milliseconds);
        }

        public void setSafe(int index, NullableIntervalDayHolder holder) {
            this.setSafe(index, holder.days, holder.milliseconds);
        }

        @Override
        public void generateTestData(int count) {
            this.setValueCount(count);
            boolean even = true;
            int valueCount = IntervalDayVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                byte b = even ? (byte)-128 : 127;
                for (int w = 0; w < 12; ++w) {
                    IntervalDayVector.this.data.setByte(i + w, b);
                }
                even = !even;
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = IntervalDayVector.this.getValueCapacity();
            int idx = 12 * valueCount;
            while (valueCount > IntervalDayVector.this.getValueCapacity()) {
                IntervalDayVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                IntervalDayVector.this.incrementAllocationMonitor();
            } else if (IntervalDayVector.this.allocationMonitor > 0) {
                IntervalDayVector.this.allocationMonitor = 0;
            }
            IntervalDayVector.this.data.writerIndex(idx);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private IntervalDayVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new IntervalDayVector(field, allocator);
        }

        public TransferImpl(IntervalDayVector to) {
            this.to = to;
        }

        @Override
        public IntervalDayVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            IntervalDayVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            IntervalDayVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, IntervalDayVector.this);
        }
    }
}

