/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.Collection;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;

public class VectorDescriptor {
    private static final String DEFAULT_NAME = "NONE";
    private final MaterializedField field;

    public VectorDescriptor(TypeProtos.MajorType type) {
        this(DEFAULT_NAME, type);
    }

    public VectorDescriptor(String name, TypeProtos.MajorType type) {
        this(MaterializedField.create(name, type));
    }

    public VectorDescriptor(MaterializedField field) {
        this.field = Preconditions.checkNotNull(field, "field cannot be null");
    }

    public MaterializedField getField() {
        return this.field;
    }

    public TypeProtos.MajorType getType() {
        return this.field.getType();
    }

    public String getName() {
        return this.field.getName();
    }

    public Collection<MaterializedField> getChildren() {
        return this.field.getChildren();
    }

    public boolean hasName() {
        return !DEFAULT_NAME.equals(this.getName());
    }

    public VectorDescriptor withName(String name) {
        return new VectorDescriptor(this.field.withPath(name));
    }

    public VectorDescriptor withType(TypeProtos.MajorType type) {
        return new VectorDescriptor(this.field.withType(type));
    }

    public static VectorDescriptor create(String name, TypeProtos.MajorType type) {
        return new VectorDescriptor(name, type);
    }

    public static VectorDescriptor create(TypeProtos.MajorType type) {
        return new VectorDescriptor(type);
    }

    public static VectorDescriptor create(MaterializedField field) {
        return new VectorDescriptor(field);
    }
}

