/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.impl;

import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;

public class HierarchicalPrinter
implements HierarchicalFormatter {
    private final PrintStream out;
    private Deque<ObjState> stack = new ArrayDeque<ObjState>();
    private int pendingExtensions = 0;
    private ObjState curObject;
    private int level;

    public HierarchicalPrinter() {
        this.out = System.out;
    }

    @Override
    public void extend() {
        ++this.pendingExtensions;
    }

    @Override
    public HierarchicalFormatter startObject(Object obj) {
        if (this.curObject != null) {
            this.stack.push(this.curObject);
            switch (this.curObject.state.ordinal()) {
                case 1: {
                    this.startAttrib(this.curObject.attrib);
                    this.curObject.attrib = null;
                    this.curObject.state = State.OBJECT;
                    break;
                }
                case 0: {
                    this.startAttrib("missing-attrib");
                    this.curObject.state = State.OBJECT;
                    break;
                }
                case 3: {
                    this.startElement(this.curObject.index);
                    this.curObject.state = State.ARRAY;
                    this.curObject.index = -1;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        this.printObjIdentity(obj);
        this.out.println(" {");
        ++this.level;
        this.curObject = new ObjState(this.pendingExtensions);
        this.pendingExtensions = 0;
        return this;
    }

    private void printObjIdentity(Object value) {
        this.out.print(value.getClass().getSimpleName());
        this.out.print(" (");
        this.out.print(System.identityHashCode(value) % 1000);
        this.out.print(")");
    }

    private void startElement(int index) {
        this.indent();
        this.out.print("[");
        this.out.print(index);
        this.out.print("] = ");
    }

    private void startAttrib(String label) {
        this.indent();
        this.out.print(label);
        this.out.print(" = ");
    }

    @Override
    public HierarchicalFormatter attribute(String label) {
        this.curObject.attrib = label;
        this.curObject.state = State.OBJECT_ATTRIB;
        return this;
    }

    @Override
    public HierarchicalFormatter attribute(String label, Object value) {
        this.attribPrefix();
        this.startAttrib(label);
        this.printValue(value);
        this.out.println();
        return this;
    }

    private void attribPrefix() {
        switch (this.curObject.state.ordinal()) {
            case 1: {
                this.startAttrib(this.curObject.attrib);
                this.out.println("<Unknown> {}");
                break;
            }
            case 0: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public HierarchicalFormatter attributeIdentity(String label, Object obj) {
        this.attribPrefix();
        this.startAttrib(label);
        this.objIdentity(obj);
        this.out.println();
        return this;
    }

    private void objIdentity(Object obj) {
        if (obj == null) {
            this.out.print("null");
        } else {
            this.printObjIdentity(obj);
        }
    }

    private void printValue(Object value) {
        if (value == null) {
            this.out.print("null");
        } else if (value instanceof String) {
            this.out.print("\"");
            this.out.print(value);
            this.out.print("\"");
        } else {
            this.out.print(value.toString());
        }
    }

    @Override
    public HierarchicalFormatter endObject() {
        if (this.level == 0) {
            this.out.println("} // Mismatch!");
            return this;
        }
        if (this.curObject.extensions == 0) {
            --this.level;
            this.indent();
            this.out.println("}");
            this.curObject = this.level == 0 ? null : this.stack.pop();
        } else {
            --this.curObject.extensions;
        }
        return this;
    }

    private void indent() {
        for (int i = 0; i < this.level; ++i) {
            this.out.print("  ");
        }
    }

    @Override
    public HierarchicalFormatter attributeArray(String label) {
        this.startAttrib(label);
        this.out.println("[");
        ++this.level;
        this.curObject.state = State.ARRAY;
        return this;
    }

    @Override
    public HierarchicalFormatter element(int index, Object value) {
        this.startElement(index);
        this.printValue(value);
        this.out.println();
        return this;
    }

    @Override
    public HierarchicalFormatter element(int index) {
        this.curObject.index = index;
        this.curObject.state = State.OBJECT_ELEMENT;
        return this;
    }

    @Override
    public HierarchicalFormatter elementIdentity(int index, Object obj) {
        this.startElement(index);
        this.objIdentity(obj);
        this.out.println();
        return this;
    }

    @Override
    public HierarchicalFormatter endArray() {
        --this.level;
        this.indent();
        this.out.println("]");
        this.curObject.state = State.OBJECT;
        return this;
    }

    private static class ObjState {
        private State state = State.OBJECT;
        private String attrib;
        private int index = -1;
        private int extensions;

        public ObjState(int extensions) {
            this.extensions = extensions;
        }
    }

    public static enum State {
        OBJECT,
        OBJECT_ATTRIB,
        ARRAY,
        OBJECT_ELEMENT;

    }
}

