/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.accessor.DictWriter;
import oadd.org.apache.drill.exec.vector.accessor.ObjectType;
import oadd.org.apache.drill.exec.vector.accessor.ObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.ValueType;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.DictEntryWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.ObjectArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.dummy.DummyArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.dummy.DummyDictWriter;
import oadd.org.apache.drill.exec.vector.complex.DictVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedDictVector;

public class ObjectDictWriter
extends ObjectArrayWriter
implements DictWriter {
    public static final int FIELD_KEY_ORDINAL = 0;
    public static final int FIELD_VALUE_ORDINAL = 1;
    private final DictEntryWriter.DictEntryObjectWriter entryObjectWriter;

    public static DictObjectWriter buildDict(ColumnMetadata metadata, DictVector vector, List<AbstractObjectWriter> keyValueWriters) {
        DictEntryWriter.DictEntryObjectWriter entryObjectWriter = DictEntryWriter.buildDictEntryWriter(metadata, keyValueWriters, vector);
        AbstractArrayWriter objectDictWriter = vector == null ? new DummyDictWriter(metadata, entryObjectWriter) : new ObjectDictWriter(metadata, vector.getOffsetVector(), entryObjectWriter);
        return new DictObjectWriter((DictWriter)((Object)objectDictWriter));
    }

    public static AbstractArrayWriter.ArrayObjectWriter buildDictArray(ColumnMetadata metadata, RepeatedDictVector vector, List<AbstractObjectWriter> keyValueWriters) {
        DictVector dataVector = vector == null ? null : (DictVector)vector.getDataVector();
        DictObjectWriter dictWriter = ObjectDictWriter.buildDict(metadata, dataVector, keyValueWriters);
        AbstractArrayWriter arrayWriter = vector == null ? new DummyArrayWriter(metadata, dictWriter) : new ObjectArrayWriter(metadata, vector.getOffsetVector(), dictWriter);
        return new AbstractArrayWriter.ArrayObjectWriter(arrayWriter);
    }

    public ObjectDictWriter(ColumnMetadata schema, UInt4Vector offsetVector, DictEntryWriter.DictEntryObjectWriter entryObjectWriter) {
        super(schema, offsetVector, entryObjectWriter);
        this.entryObjectWriter = entryObjectWriter;
    }

    @Override
    public ValueType keyType() {
        return this.tuple().scalar(0).valueType();
    }

    @Override
    public ObjectType valueType() {
        return this.tuple().type(1);
    }

    @Override
    public ScalarWriter keyWriter() {
        return this.tuple().scalar(0);
    }

    @Override
    public ObjectWriter valueWriter() {
        return this.tuple().column(1);
    }

    @Override
    public void setObject(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                this.entryObjectWriter.setKeyValue(entry.getKey(), entry.getValue());
                this.save();
            }
        } else {
            int size = Array.getLength(object);
            assert (size % 2 == 0);
            for (int i = 0; i < size; i += 2) {
                Object key = Array.get(object, i);
                Object value = Array.get(object, i + 1);
                this.entryObjectWriter.setKeyValue(key, value);
                this.save();
            }
        }
    }

    public static class DictObjectWriter
    extends AbstractArrayWriter.ArrayObjectWriter {
        public DictObjectWriter(DictWriter dictWriter) {
            super((AbstractArrayWriter)((Object)dictWriter));
        }

        @Override
        public DictWriter dict() {
            return (DictWriter)((Object)this.arrayWriter);
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("dictWriter");
            this.arrayWriter.dump(format);
            format.endObject();
        }
    }
}

