/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.RepeatedDictHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.CallBack;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.DictVector;
import oadd.org.apache.drill.exec.vector.complex.EmptyValuePopulator;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedDictReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public class RepeatedDictVector
extends BaseRepeatedValueVector {
    public static final TypeProtos.MajorType TYPE = Types.repeated(TypeProtos.MinorType.DICT);
    private static final String DICT_VECTOR_NAME = "$inner$";
    private static final MaterializedField DICT_VECTOR_FIELD = MaterializedField.create("$inner$", DictVector.TYPE);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private final FieldReader reader = new RepeatedDictReaderImpl(this);
    private final EmptyValuePopulator emptyPopulator = new EmptyValuePopulator(this.getOffsetVector());

    public RepeatedDictVector(String path, BufferAllocator allocator) {
        this(MaterializedField.create(path, TYPE), allocator, (CallBack)null);
    }

    public RepeatedDictVector(MaterializedField field, BufferAllocator allocator, CallBack callback) {
        super(field, allocator, new DictVector(DICT_VECTOR_FIELD, allocator, callback));
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException();
        }
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.makeTransferPair(new RepeatedDictVector(ref, allocator));
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new RepeatedDictTransferPair((RepeatedDictVector)target);
    }

    @Override
    public MaterializedField getField() {
        MaterializedField field = this.field.clone();
        field.addChild(this.vector.getField());
        return field;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        RepeatedDictTransferPair pair = (RepeatedDictTransferPair)from.makeTransferPair(this);
        pair.copyValueSafe(fromIndex, toIndex);
    }

    public class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        @Override
        public Object getObject(int index) {
            JsonStringArrayList<Object> list = new JsonStringArrayList<Object>();
            int start = RepeatedDictVector.this.offsets.getAccessor().get(index);
            int end = RepeatedDictVector.this.offsets.getAccessor().get(index + 1);
            for (int i = start; i < end; ++i) {
                list.add(RepeatedDictVector.this.vector.getAccessor().getObject(i));
            }
            return list;
        }

        public void get(int index, RepeatedDictHolder holder) {
            int valueCapacity = RepeatedDictVector.this.getValueCapacity();
            assert (index < valueCapacity) : String.format("Attempted to access index %d when value capacity is %d", index, valueCapacity);
            holder.vector = RepeatedDictVector.this;
            holder.reader = RepeatedDictVector.this.reader;
            holder.start = RepeatedDictVector.this.getOffsetVector().getAccessor().get(index);
            holder.end = RepeatedDictVector.this.getOffsetVector().getAccessor().get(index + 1);
        }
    }

    public class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator {
        @Override
        public void startNewValue(int index) {
            RepeatedDictVector.this.emptyPopulator.populate(index + 1);
            RepeatedDictVector.this.offsets.getMutator().setSafe(index + 1, RepeatedDictVector.this.offsets.getAccessor().get(index));
        }

        @Override
        public void setValueCount(int topLevelValueCount) {
            RepeatedDictVector.this.emptyPopulator.populate(topLevelValueCount);
            RepeatedDictVector.this.offsets.getMutator().setValueCount(topLevelValueCount == 0 ? 0 : topLevelValueCount + 1);
            int childValueCount = RepeatedDictVector.this.offsets.getAccessor().get(topLevelValueCount);
            RepeatedDictVector.this.vector.getMutator().setValueCount(childValueCount);
        }

        public int add(int index) {
            int prevEnd = RepeatedDictVector.this.offsets.getAccessor().get(index + 1);
            RepeatedDictVector.this.offsets.getMutator().setSafe(index + 1, prevEnd + 1);
            return prevEnd;
        }
    }

    public class RepeatedDictTransferPair
    extends BaseRepeatedValueVector.BaseRepeatedValueVectorTransferPair<RepeatedDictVector> {
        public RepeatedDictTransferPair(RepeatedDictVector target) {
            super((BaseRepeatedValueVector)RepeatedDictVector.this, (BaseRepeatedValueVector)target);
        }

        @Override
        public void copyValueSafe(int srcIndex, int destIndex) {
            RepeatedDictHolder holder = new RepeatedDictHolder();
            RepeatedDictVector.this.getAccessor().get(srcIndex, holder);
            ((RepeatedDictVector)this.target).emptyPopulator.populate(destIndex + 1);
            this.copyValueSafe(destIndex, holder.start, holder.end);
        }
    }
}

