/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.fn;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.expr.holders.VarBinaryHolder;
import oadd.org.apache.drill.exec.expr.holders.VarCharHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkingBuffer {
    static final Logger logger = LoggerFactory.getLogger(WorkingBuffer.class);
    private DrillBuf workBuf;

    public WorkingBuffer(DrillBuf workBuf) {
        this.workBuf = workBuf;
    }

    private void ensure(int length) {
        this.workBuf = this.workBuf.reallocIfNeeded(length);
    }

    public void prepareVarCharHolder(String value, VarCharHolder h2) throws IOException {
        byte[] b = value.getBytes(StandardCharsets.UTF_8);
        this.ensure(b.length);
        this.workBuf.setBytes(0, b);
        h2.start = 0;
        h2.end = b.length;
        h2.buffer = this.workBuf;
    }

    public int prepareVarCharHolder(String value) throws IOException {
        byte[] b = value.getBytes(StandardCharsets.UTF_8);
        this.ensure(b.length);
        this.workBuf.setBytes(0, b);
        return b.length;
    }

    public void prepareBinary(byte[] b, VarBinaryHolder h2) throws IOException {
        this.ensure(b.length);
        this.workBuf.setBytes(0, b);
        h2.start = 0;
        h2.end = b.length;
        h2.buffer = this.workBuf;
    }

    public DrillBuf getBuf() {
        return this.workBuf;
    }
}

