/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.util.ArrayList;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableIntHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedIntHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedIntWriterImpl;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.IntWriter;

public class RepeatedIntHolderReaderImpl
extends AbstractFieldReader {
    private NullableIntHolder holder = new NullableIntHolder();
    private int index = -1;
    private RepeatedIntHolder repeatedHolder;

    public RepeatedIntHolderReaderImpl(RepeatedIntHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return RepeatedIntHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public Integer readInteger(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        Integer value = this.readInteger();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public Integer readInteger() {
        if (!this.isSet()) {
            return null;
        }
        Integer value = new Integer(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        ArrayList<Integer> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        Integer value = new Integer(this.holder.value);
        return value;
    }

    @Override
    public void copyAsValue(IntWriter writer) {
        RepeatedIntWriterImpl impl = (RepeatedIntWriterImpl)writer;
        impl.vector.getMutator().setSafe(impl.idx(), this.repeatedHolder);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        RepeatedIntWriterImpl impl = (RepeatedIntWriterImpl)writer.list(name).integer();
        impl.vector.getMutator().setSafe(impl.idx(), this.repeatedHolder);
    }
}

