/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.fs.FileChecksum;
import oadd.org.apache.hadoop.fs.Options;
import oadd.org.apache.hadoop.util.CrcUtil;
import oadd.org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public class CompositeCrcFileChecksum
extends FileChecksum {
    public static final int LENGTH = 4;
    private int crc;
    private DataChecksum.Type crcType;
    private int bytesPerCrc;

    public CompositeCrcFileChecksum(int crc, DataChecksum.Type crcType, int bytesPerCrc) {
        this.crc = crc;
        this.crcType = crcType;
        this.bytesPerCrc = bytesPerCrc;
    }

    @Override
    public String getAlgorithmName() {
        return "COMPOSITE-" + this.crcType.name();
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public byte[] getBytes() {
        return CrcUtil.intToBytes(this.crc);
    }

    @Override
    public Options.ChecksumOpt getChecksumOpt() {
        return new Options.ChecksumOpt(this.crcType, this.bytesPerCrc);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.crc = in.readInt();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.crc);
    }

    public String toString() {
        return this.getAlgorithmName() + ":" + String.format("0x%08x", this.crc);
    }
}

