/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs;

import java.io.IOException;
import java.util.List;
import oadd.org.apache.commons.lang3.builder.ToStringBuilder;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.fs.FileStatus;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.ipc.RemoteException;
import oadd.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class PartialListing<T extends FileStatus> {
    private final Path listedPath;
    private final List<T> partialListing;
    private final RemoteException exception;

    public PartialListing(Path listedPath, List<T> partialListing) {
        this(listedPath, partialListing, null);
    }

    public PartialListing(Path listedPath, RemoteException exception) {
        this(listedPath, null, exception);
    }

    private PartialListing(Path listedPath, List<T> partialListing, RemoteException exception) {
        Preconditions.checkArgument(partialListing == null ^ exception == null);
        this.partialListing = partialListing;
        this.listedPath = listedPath;
        this.exception = exception;
    }

    public List<T> get() throws IOException {
        if (this.exception != null) {
            throw this.exception.unwrapRemoteException();
        }
        return this.partialListing;
    }

    public Path getListedPath() {
        return this.listedPath;
    }

    public String toString() {
        return new ToStringBuilder(this).append("listedPath", this.listedPath).append("partialListing", this.partialListing).append("exception", this.exception).toString();
    }
}

