/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import oadd.org.apache.hadoop.fs.ByteBufferPositionedReadable;
import oadd.org.apache.hadoop.fs.FileRange;
import oadd.org.apache.hadoop.fs.PositionedReadable;
import oadd.org.apache.hadoop.fs.impl.CombinedFileRange;
import oadd.org.apache.hadoop.util.Preconditions;
import oadd.org.apache.hadoop.util.functional.Function4RaisingIOE;

public final class VectoredReadUtils {
    private static final int TMP_BUFFER_MAX_SIZE = 65536;

    public static void validateRangeRequest(FileRange range) throws EOFException {
        Preconditions.checkArgument(range.getLength() >= 0, "length is negative");
        if (range.getOffset() < 0L) {
            throw new EOFException("position is negative");
        }
    }

    public static void validateVectoredReadRanges(List<? extends FileRange> ranges) throws EOFException {
        for (FileRange fileRange : ranges) {
            VectoredReadUtils.validateRangeRequest(fileRange);
        }
    }

    public static void readVectored(PositionedReadable stream, List<? extends FileRange> ranges, IntFunction<ByteBuffer> allocate) {
        for (FileRange fileRange : ranges) {
            fileRange.setData(VectoredReadUtils.readRangeFrom(stream, fileRange, allocate));
        }
    }

    public static CompletableFuture<ByteBuffer> readRangeFrom(PositionedReadable stream, FileRange range, IntFunction<ByteBuffer> allocate) {
        CompletableFuture<ByteBuffer> result = new CompletableFuture<ByteBuffer>();
        try {
            ByteBuffer buffer = allocate.apply(range.getLength());
            if (stream instanceof ByteBufferPositionedReadable) {
                ((ByteBufferPositionedReadable)((Object)stream)).readFully(range.getOffset(), buffer);
                buffer.flip();
            } else {
                VectoredReadUtils.readNonByteBufferPositionedReadable(stream, range, buffer);
            }
            result.complete(buffer);
        }
        catch (IOException ioe) {
            result.completeExceptionally(ioe);
        }
        return result;
    }

    private static void readNonByteBufferPositionedReadable(PositionedReadable stream, FileRange range, ByteBuffer buffer) throws IOException {
        if (buffer.isDirect()) {
            VectoredReadUtils.readInDirectBuffer(range.getLength(), buffer, (position, buffer1, offset, length) -> {
                stream.readFully(position.intValue(), (byte[])buffer1, (int)offset, (int)length);
                return null;
            });
            buffer.flip();
        } else {
            stream.readFully(range.getOffset(), buffer.array(), buffer.arrayOffset(), range.getLength());
        }
    }

    public static void readInDirectBuffer(int length, ByteBuffer buffer, Function4RaisingIOE<Integer, byte[], Integer, Integer, Void> operation) throws IOException {
        int currentLength;
        if (length == 0) {
            return;
        }
        int position = 0;
        int tmpBufferMaxSize = Math.min(65536, length);
        byte[] tmp = new byte[tmpBufferMaxSize];
        for (int readBytes = 0; readBytes < length; readBytes += currentLength) {
            currentLength = readBytes + tmpBufferMaxSize < length ? tmpBufferMaxSize : length - readBytes;
            operation.apply(position, tmp, 0, currentLength);
            buffer.put(tmp, 0, currentLength);
            position += currentLength;
        }
    }

    public static boolean isOrderedDisjoint(List<? extends FileRange> input, int chunkSize, int minimumSeek) {
        long previous = -minimumSeek;
        for (FileRange fileRange : input) {
            long offset = fileRange.getOffset();
            long end = fileRange.getOffset() + (long)fileRange.getLength();
            if (offset % (long)chunkSize != 0L || end % (long)chunkSize != 0L || offset - previous < (long)minimumSeek) {
                return false;
            }
            previous = end;
        }
        return true;
    }

    public static long roundDown(long offset, int chunkSize) {
        if (chunkSize > 1) {
            return offset - offset % (long)chunkSize;
        }
        return offset;
    }

    public static long roundUp(long offset, int chunkSize) {
        if (chunkSize > 1) {
            long next = offset + (long)chunkSize - 1L;
            return next - next % (long)chunkSize;
        }
        return offset;
    }

    public static List<? extends FileRange> validateNonOverlappingAndReturnSortedRanges(List<? extends FileRange> input) {
        if (input.size() <= 1) {
            return input;
        }
        FileRange[] sortedRanges = VectoredReadUtils.sortRanges(input);
        FileRange prev = sortedRanges[0];
        for (int i = 1; i < sortedRanges.length; ++i) {
            if (sortedRanges[i].getOffset() < prev.getOffset() + (long)prev.getLength()) {
                throw new UnsupportedOperationException("Overlapping ranges are not supported");
            }
            prev = sortedRanges[i];
        }
        return Arrays.asList(sortedRanges);
    }

    public static FileRange[] sortRanges(List<? extends FileRange> input) {
        FileRange[] sortedRanges = input.toArray(new FileRange[0]);
        Arrays.sort(sortedRanges, Comparator.comparingLong(FileRange::getOffset));
        return sortedRanges;
    }

    public static List<CombinedFileRange> mergeSortedRanges(List<? extends FileRange> sortedRanges, int chunkSize, int minimumSeek, int maxSize) {
        CombinedFileRange current = null;
        ArrayList<CombinedFileRange> result = new ArrayList<CombinedFileRange>(sortedRanges.size());
        for (FileRange fileRange : sortedRanges) {
            long start = VectoredReadUtils.roundDown(fileRange.getOffset(), chunkSize);
            long end = VectoredReadUtils.roundUp(fileRange.getOffset() + (long)fileRange.getLength(), chunkSize);
            if (current != null && current.merge(start, end, fileRange, minimumSeek, maxSize)) continue;
            current = new CombinedFileRange(start, end, fileRange);
            result.add(current);
        }
        return result;
    }

    public static ByteBuffer sliceTo(ByteBuffer readData, long readOffset, FileRange request) {
        int offsetChange = (int)(request.getOffset() - readOffset);
        int requestLength = request.getLength();
        readData = readData.slice();
        readData.position(offsetChange);
        readData.limit(offsetChange + requestLength);
        readData = readData.slice();
        return readData;
    }

    private VectoredReadUtils() {
        throw new UnsupportedOperationException();
    }
}

