/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.impl;

import java.lang.ref.WeakReference;
import java.util.Objects;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.metrics2.MetricsCollector;
import oadd.org.apache.hadoop.metrics2.MetricsSource;

@InterfaceAudience.Private
public class WeakRefMetricsSource
implements MetricsSource {
    private final String name;
    private final WeakReference<MetricsSource> sourceWeakReference;

    public WeakRefMetricsSource(String name, MetricsSource source) {
        this.name = name;
        this.sourceWeakReference = new WeakReference<MetricsSource>(Objects.requireNonNull(source));
    }

    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsSource metricsSource = (MetricsSource)this.sourceWeakReference.get();
        if (metricsSource != null) {
            metricsSource.getMetrics(collector, all);
        }
    }

    public String getName() {
        return this.name;
    }

    public MetricsSource getSource() {
        return (MetricsSource)this.sourceWeakReference.get();
    }

    public String toString() {
        return "WeakRefMetricsSource{name='" + this.name + '\'' + ", sourceWeakReference is " + (this.sourceWeakReference.get() == null ? "unset" : "set") + '}';
    }
}

