/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import oadd.org.apache.hadoop.fs.CreateFlag;
import oadd.org.apache.hadoop.fs.FSDataOutputStream;
import oadd.org.apache.hadoop.fs.FileSystem;
import oadd.org.apache.hadoop.fs.FilterFileSystem;
import oadd.org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import oadd.org.apache.hadoop.fs.Path;
import oadd.org.apache.hadoop.fs.PathExistsException;
import oadd.org.apache.hadoop.fs.PathIOException;
import oadd.org.apache.hadoop.fs.PathIsDirectoryException;
import oadd.org.apache.hadoop.fs.PathIsNotDirectoryException;
import oadd.org.apache.hadoop.fs.PathNotFoundException;
import oadd.org.apache.hadoop.fs.PathOperationException;
import oadd.org.apache.hadoop.fs.permission.AclEntry;
import oadd.org.apache.hadoop.fs.permission.AclUtil;
import oadd.org.apache.hadoop.fs.permission.FsPermission;
import oadd.org.apache.hadoop.fs.shell.FsCommand;
import oadd.org.apache.hadoop.fs.shell.PathData;
import oadd.org.apache.hadoop.fs.viewfs.NotInMountpointException;
import oadd.org.apache.hadoop.io.IOUtils;
import oadd.org.apache.hadoop.util.functional.FutureIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CommandWithDestination
extends FsCommand {
    protected static final Logger LOG = LoggerFactory.getLogger(CommandWithDestination.class);
    protected PathData dst;
    private boolean overwrite = false;
    private boolean verifyChecksum = true;
    private boolean writeChecksum = true;
    private boolean lazyPersist = false;
    private boolean direct = false;
    private static final String RAW = "raw.";
    private static final String RESERVED_RAW = "/.reserved/raw";
    private EnumSet<FileAttribute> preserveStatus = EnumSet.noneOf(FileAttribute.class);

    CommandWithDestination() {
    }

    protected void setOverwrite(boolean flag) {
        this.overwrite = flag;
    }

    protected void setLazyPersist(boolean flag) {
        this.lazyPersist = flag;
    }

    protected void setVerifyChecksum(boolean flag) {
        this.verifyChecksum = flag;
    }

    protected void setWriteChecksum(boolean flag) {
        this.writeChecksum = flag;
    }

    protected void setDirectWrite(boolean flag) {
        this.direct = flag;
    }

    protected void setPreserve(boolean preserve) {
        if (preserve) {
            this.preserve(FileAttribute.TIMESTAMPS);
            this.preserve(FileAttribute.OWNERSHIP);
            this.preserve(FileAttribute.PERMISSION);
        } else {
            this.preserveStatus.clear();
        }
    }

    private boolean shouldPreserve(FileAttribute attribute) {
        return this.preserveStatus.contains((Object)attribute);
    }

    protected void preserve(FileAttribute fileAttribute) {
        for (FileAttribute attribute : this.preserveStatus) {
            if (!attribute.equals((Object)fileAttribute)) continue;
            return;
        }
        this.preserveStatus.add(fileAttribute);
    }

    protected void getLocalDestination(LinkedList<String> args) throws IOException {
        String pathString = args.size() < 2 ? "." : args.removeLast();
        try {
            this.dst = new PathData(new URI(pathString), this.getConf());
        }
        catch (URISyntaxException e) {
            if (Path.WINDOWS) {
                this.dst = new PathData(pathString, this.getConf());
            }
            throw new IOException("unexpected URISyntaxException", e);
        }
    }

    protected void getRemoteDestination(LinkedList<String> args) throws IOException {
        if (args.size() < 2) {
            this.dst = new PathData(".", this.getConf());
        } else {
            String pathString = args.removeLast();
            PathData[] items = PathData.expandAsGlob(pathString, this.getConf());
            switch (items.length) {
                case 0: {
                    throw new PathNotFoundException(pathString);
                }
                case 1: {
                    this.dst = items[0];
                    break;
                }
                default: {
                    throw new PathIOException(pathString, "Too many matches");
                }
            }
        }
    }

    @Override
    protected void processArguments(LinkedList<PathData> args) throws IOException {
        if (args.size() > 1) {
            if (!this.dst.exists) {
                throw new PathNotFoundException(this.dst.toString());
            }
            if (!this.dst.stat.isDirectory()) {
                throw new PathIsNotDirectoryException(this.dst.toString());
            }
        } else if (this.dst.exists) {
            if (!this.dst.stat.isDirectory() && !this.overwrite) {
                LOG.debug("Destination file exists: {}", (Object)this.dst.stat);
                throw new PathExistsException(this.dst.toString());
            }
        } else if (!this.dst.parentExists()) {
            throw new PathNotFoundException(this.dst.toString()).withFullyQualifiedPath(this.dst.path.toUri().toString());
        }
        super.processArguments(args);
    }

    @Override
    protected void processPathArgument(PathData src) throws IOException {
        if (src.stat.isDirectory() && src.fs.equals(this.dst.fs)) {
            PathData target = this.getTargetPath(src);
            String srcPath = src.fs.makeQualified(src.path).toString();
            String dstPath = this.dst.fs.makeQualified(target.path).toString();
            if (dstPath.equals(srcPath)) {
                PathIOException e = new PathIOException(src.toString(), "are identical");
                e.setTargetPath(dstPath.toString());
                throw e;
            }
            if (!srcPath.endsWith("/")) {
                srcPath = srcPath + "/";
            }
            if (dstPath.startsWith(srcPath)) {
                PathIOException e = new PathIOException(src.toString(), "is a subdirectory of itself");
                e.setTargetPath(target.toString());
                throw e;
            }
        }
        super.processPathArgument(src);
    }

    @Override
    protected void processPath(PathData src) throws IOException {
        this.processPath(src, this.getTargetPath(src));
    }

    protected void processPath(PathData src, PathData dst) throws IOException {
        if (src.stat.isSymlink()) {
            throw new PathOperationException(src.toString());
        }
        if (src.stat.isFile()) {
            this.copyFileToTarget(src, dst);
        } else if (src.stat.isDirectory() && !this.isRecursive()) {
            throw new PathIsDirectoryException(src.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recursePath(PathData src) throws IOException {
        PathData savedDst = this.dst;
        try {
            this.dst = this.getTargetPath(src);
            boolean preserveRawXattrs = this.checkPathsForReservedRaw(src.path, this.dst.path);
            if (this.dst.exists) {
                if (!this.dst.stat.isDirectory()) {
                    throw new PathIsNotDirectoryException(this.dst.toString());
                }
            } else {
                if (!this.dst.fs.mkdirs(this.dst.path)) {
                    PathIOException e = new PathIOException(this.dst.toString());
                    e.setOperation("mkdir");
                    throw e;
                }
                this.dst.refreshStatus();
            }
            super.recursePath(src);
            if (this.dst.stat.isDirectory()) {
                this.preserveAttributes(src, this.dst, preserveRawXattrs);
            }
        }
        finally {
            this.dst = savedDst;
        }
    }

    protected PathData getTargetPath(PathData src) throws IOException {
        PathData target = this.getDepth() > 0 || this.dst.exists && this.dst.stat.isDirectory() ? this.dst.getPathDataForChild(src) : (this.dst.representsDirectory() ? this.dst.getPathDataForChild(src) : this.dst);
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFileToTarget(PathData src, PathData target) throws IOException {
        boolean preserveRawXattrs = this.checkPathsForReservedRaw(src.path, target.path);
        src.fs.setVerifyChecksum(this.verifyChecksum);
        InputStream in = null;
        try {
            in = (InputStream)FutureIO.awaitFuture(((FutureDataInputStreamBuilder)src.fs.openFile(src.path).withFileStatus(src.stat).opt("fs.option.openfile.read.policy", "whole-file")).build());
            this.copyStreamToTarget(in, target);
            this.preserveAttributes(src, target, preserveRawXattrs);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream(in);
    }

    private boolean checkPathsForReservedRaw(Path src, Path target) throws PathOperationException {
        boolean srcIsRR = Path.getPathWithoutSchemeAndAuthority(src).toString().startsWith(RESERVED_RAW);
        boolean dstIsRR = Path.getPathWithoutSchemeAndAuthority(target).toString().startsWith(RESERVED_RAW);
        boolean preserveRawXattrs = false;
        if (srcIsRR && !dstIsRR) {
            String s2 = "' copy from '/.reserved/raw' to non '/.reserved/raw'. Either both source and target must be in '/.reserved/raw' or neither.";
            throw new PathOperationException("'" + src.toString() + "' copy from '/.reserved/raw' to non '/.reserved/raw'. Either both source and target must be in '/.reserved/raw' or neither.");
        }
        if (!srcIsRR && dstIsRR) {
            String s3 = "' copy from non '/.reserved/raw' to '/.reserved/raw'. Either both source and target must be in '/.reserved/raw' or neither.";
            throw new PathOperationException("'" + this.dst.toString() + "' copy from non '/.reserved/raw' to '/.reserved/raw'. Either both source and target must be in '/.reserved/raw' or neither.");
        }
        if (srcIsRR && dstIsRR) {
            preserveRawXattrs = true;
        }
        return preserveRawXattrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyStreamToTarget(InputStream in, PathData target) throws IOException {
        if (target.exists && (target.stat.isDirectory() || !this.overwrite)) {
            throw new PathExistsException(target.toString());
        }
        try (TargetFileSystem targetFs = new TargetFileSystem(target.fs);){
            PathData tempTarget = this.direct ? target : target.suffix("._COPYING_");
            targetFs.setWriteChecksum(this.writeChecksum);
            targetFs.writeStreamToFile(in, tempTarget, this.lazyPersist, this.direct);
            if (!this.direct) {
                targetFs.rename(tempTarget, target);
            }
        }
    }

    protected void preserveAttributes(PathData src, PathData target, boolean preserveRawXAttrs) throws IOException {
        Map<String, byte[]> srcXAttrs;
        boolean preserveXAttrs;
        if (this.shouldPreserve(FileAttribute.TIMESTAMPS)) {
            target.fs.setTimes(target.path, src.stat.getModificationTime(), src.stat.getAccessTime());
        }
        if (this.shouldPreserve(FileAttribute.OWNERSHIP)) {
            target.fs.setOwner(target.path, src.stat.getOwner(), src.stat.getGroup());
        }
        if (this.shouldPreserve(FileAttribute.PERMISSION) || this.shouldPreserve(FileAttribute.ACL)) {
            target.fs.setPermission(target.path, src.stat.getPermission());
        }
        if (this.shouldPreserve(FileAttribute.ACL) && src.stat.hasAcl()) {
            FsPermission perm = src.stat.getPermission();
            List<AclEntry> srcEntries = src.fs.getAclStatus(src.path).getEntries();
            List<AclEntry> srcFullEntries = AclUtil.getAclFromPermAndEntries(perm, srcEntries);
            target.fs.setAcl(target.path, srcFullEntries);
        }
        if (((preserveXAttrs = this.shouldPreserve(FileAttribute.XATTR)) || preserveRawXAttrs) && (srcXAttrs = src.fs.getXAttrs(src.path)) != null) {
            for (Map.Entry<String, byte[]> entry : srcXAttrs.entrySet()) {
                String xattrName = entry.getKey();
                if (!xattrName.startsWith(RAW) && !preserveXAttrs) continue;
                target.fs.setXAttr(target.path, entry.getKey(), entry.getValue());
            }
        }
    }

    private static class TargetFileSystem
    extends FilterFileSystem {
        TargetFileSystem(FileSystem fs) {
            super(fs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeStreamToFile(InputStream in, PathData target, boolean lazyPersist, boolean direct) throws IOException {
            FSDataOutputStream out = null;
            try {
                out = this.create(target, lazyPersist);
                IOUtils.copyBytes(in, (OutputStream)out, this.getConf(), true);
            }
            finally {
                if (!direct) {
                    this.deleteOnExit(target.path);
                }
                IOUtils.closeStream(out);
            }
        }

        FSDataOutputStream create(PathData item, boolean lazyPersist) throws IOException {
            if (lazyPersist) {
                long defaultBlockSize;
                try {
                    defaultBlockSize = this.getDefaultBlockSize();
                }
                catch (NotInMountpointException ex) {
                    defaultBlockSize = this.getDefaultBlockSize(item.path);
                }
                EnumSet<CreateFlag> createFlags = EnumSet.of(CreateFlag.CREATE, CreateFlag.LAZY_PERSIST, CreateFlag.OVERWRITE);
                return this.create(item.path, FsPermission.getFileDefault().applyUMask(FsPermission.getUMask(this.getConf())), createFlags, this.getConf().getInt("oadd.io.file.buffer.size", 4096), (short)1, defaultBlockSize, null, null);
            }
            return this.create(item.path, true);
        }

        void rename(PathData src, PathData target) throws IOException {
            if (target.exists && !this.delete(target.path, false)) {
                PathIOException e = new PathIOException(target.toString());
                e.setOperation("delete");
                throw e;
            }
            if (!this.rename(src.path, target.path)) {
                PathIOException e = new PathIOException(src.toString());
                e.setOperation("rename");
                e.setTargetPath(target.toString());
                throw e;
            }
            this.cancelDeleteOnExit(src.path);
        }

        @Override
        public void close() {
            this.processDeleteOnExit();
        }
    }

    protected static enum FileAttribute {
        TIMESTAMPS,
        OWNERSHIP,
        PERMISSION,
        ACL,
        XATTR;


        public static FileAttribute getAttribute(char symbol) {
            for (FileAttribute attribute : FileAttribute.values()) {
                if (attribute.name().charAt(0) != Character.toUpperCase(symbol)) continue;
                return attribute;
            }
            throw new NoSuchElementException("No attribute for " + symbol);
        }
    }
}

